/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryCommodityListRequest
extends Request {
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;

    private QueryCommodityListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.lang = builder.lang;
        this.productCode = builder.productCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryCommodityListRequest create() {
        return QueryCommodityListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getLang() {
        return this.lang;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public static final class Builder
    extends Request.Builder<QueryCommodityListRequest, Builder> {
        private String lang;
        private String productCode;

        private Builder() {
        }

        private Builder(QueryCommodityListRequest request) {
            super((Request)request);
            this.lang = request.lang;
            this.productCode = request.productCode;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public QueryCommodityListRequest build() {
            return new QueryCommodityListRequest(this);
        }
    }
}

