/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryProductListRequest
extends Request {
    @Query
    @NameInMap(value="PageNum")
    @Validation(required=true)
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="QueryTotalCount")
    private Boolean queryTotalCount;

    private QueryProductListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.queryTotalCount = builder.queryTotalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryProductListRequest create() {
        return QueryProductListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Boolean getQueryTotalCount() {
        return this.queryTotalCount;
    }

    public static final class Builder
    extends Request.Builder<QueryProductListRequest, Builder> {
        private Integer pageNum;
        private Integer pageSize;
        private Boolean queryTotalCount;

        private Builder() {
        }

        private Builder(QueryProductListRequest request) {
            super((Request)request);
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.queryTotalCount = request.queryTotalCount;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder queryTotalCount(Boolean queryTotalCount) {
            this.putQueryParameter("QueryTotalCount", queryTotalCount);
            this.queryTotalCount = queryTotalCount;
            return this;
        }

        public QueryProductListRequest build() {
            return new QueryProductListRequest(this);
        }
    }
}

