/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class QueryRelationListRequest
extends Request {
    @Query
    @NameInMap(value="PageNum")
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="StatusList")
    private List<String> statusList;
    @Query
    @NameInMap(value="UserId")
    @Validation(required=true)
    private Long userId;

    private QueryRelationListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.statusList = builder.statusList;
        this.userId = builder.userId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryRelationListRequest create() {
        return QueryRelationListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public List<String> getStatusList() {
        return this.statusList;
    }

    public Long getUserId() {
        return this.userId;
    }

    public static final class Builder
    extends Request.Builder<QueryRelationListRequest, Builder> {
        private Integer pageNum;
        private Integer pageSize;
        private List<String> statusList;
        private Long userId;

        private Builder() {
        }

        private Builder(QueryRelationListRequest request) {
            super((Request)request);
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.statusList = request.statusList;
            this.userId = request.userId;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder statusList(List<String> statusList) {
            this.putQueryParameter("StatusList", statusList);
            this.statusList = statusList;
            return this;
        }

        public Builder userId(Long userId) {
            this.putQueryParameter("UserId", userId);
            this.userId = userId;
            return this;
        }

        public QueryRelationListRequest build() {
            return new QueryRelationListRequest(this);
        }
    }
}

