/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;
import java.util.Map;

public class QuerySkuPriceListRequest
extends Request {
    @Query
    @NameInMap(value="CommodityCode")
    @Validation(required=true)
    private String commodityCode;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="NextPageToken")
    private String nextPageToken;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Query
    @NameInMap(value="PriceEntityCode")
    @Validation(required=true)
    private String priceEntityCode;
    @Query
    @NameInMap(value="PriceFactorConditionMap")
    private Map<String, List<String>> priceFactorConditionMap;

    private QuerySkuPriceListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.commodityCode = builder.commodityCode;
        this.lang = builder.lang;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.priceEntityCode = builder.priceEntityCode;
        this.priceFactorConditionMap = builder.priceFactorConditionMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QuerySkuPriceListRequest create() {
        return QuerySkuPriceListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCommodityCode() {
        return this.commodityCode;
    }

    public String getLang() {
        return this.lang;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getPriceEntityCode() {
        return this.priceEntityCode;
    }

    public Map<String, List<String>> getPriceFactorConditionMap() {
        return this.priceFactorConditionMap;
    }

    public static final class Builder
    extends Request.Builder<QuerySkuPriceListRequest, Builder> {
        private String commodityCode;
        private String lang;
        private String nextPageToken;
        private Integer pageSize;
        private String priceEntityCode;
        private Map<String, List<String>> priceFactorConditionMap;

        private Builder() {
        }

        private Builder(QuerySkuPriceListRequest request) {
            super((Request)request);
            this.commodityCode = request.commodityCode;
            this.lang = request.lang;
            this.nextPageToken = request.nextPageToken;
            this.pageSize = request.pageSize;
            this.priceEntityCode = request.priceEntityCode;
            this.priceFactorConditionMap = request.priceFactorConditionMap;
        }

        public Builder commodityCode(String commodityCode) {
            this.putQueryParameter("CommodityCode", commodityCode);
            this.commodityCode = commodityCode;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.putQueryParameter("NextPageToken", nextPageToken);
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder priceEntityCode(String priceEntityCode) {
            this.putQueryParameter("PriceEntityCode", priceEntityCode);
            this.priceEntityCode = priceEntityCode;
            return this;
        }

        public Builder priceFactorConditionMap(Map<String, List<String>> priceFactorConditionMap) {
            String priceFactorConditionMapShrink = this.shrink(priceFactorConditionMap, "PriceFactorConditionMap", "json");
            this.putQueryParameter("PriceFactorConditionMap", priceFactorConditionMapShrink);
            this.priceFactorConditionMap = priceFactorConditionMap;
            return this;
        }

        public QuerySkuPriceListRequest build() {
            return new QuerySkuPriceListRequest(this);
        }
    }
}

