/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ReleaseInstanceRequest
extends Request {
    @Query
    @NameInMap(value="InstanceIds")
    @Validation(required=true)
    private String instanceIds;
    @Query
    @NameInMap(value="OwnerId")
    @Validation(required=true)
    private Long ownerId;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;
    @Query
    @NameInMap(value="ProductType")
    private String productType;
    @Query
    @NameInMap(value="Region")
    private String region;
    @Query
    @NameInMap(value="RenewStatus")
    private String renewStatus;
    @Query
    @NameInMap(value="SubscriptionType")
    @Validation(required=true)
    private String subscriptionType;

    private ReleaseInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceIds = builder.instanceIds;
        this.ownerId = builder.ownerId;
        this.productCode = builder.productCode;
        this.productType = builder.productType;
        this.region = builder.region;
        this.renewStatus = builder.renewStatus;
        this.subscriptionType = builder.subscriptionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReleaseInstanceRequest create() {
        return ReleaseInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceIds() {
        return this.instanceIds;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRenewStatus() {
        return this.renewStatus;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public static final class Builder
    extends Request.Builder<ReleaseInstanceRequest, Builder> {
        private String instanceIds;
        private Long ownerId;
        private String productCode;
        private String productType;
        private String region;
        private String renewStatus;
        private String subscriptionType;

        private Builder() {
        }

        private Builder(ReleaseInstanceRequest request) {
            super((Request)request);
            this.instanceIds = request.instanceIds;
            this.ownerId = request.ownerId;
            this.productCode = request.productCode;
            this.productType = request.productType;
            this.region = request.region;
            this.renewStatus = request.renewStatus;
            this.subscriptionType = request.subscriptionType;
        }

        public Builder instanceIds(String instanceIds) {
            this.putQueryParameter("InstanceIds", instanceIds);
            this.instanceIds = instanceIds;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public Builder productType(String productType) {
            this.putQueryParameter("ProductType", productType);
            this.productType = productType;
            return this;
        }

        public Builder region(String region) {
            this.putQueryParameter("Region", region);
            this.region = region;
            return this;
        }

        public Builder renewStatus(String renewStatus) {
            this.putQueryParameter("RenewStatus", renewStatus);
            this.renewStatus = renewStatus;
            return this;
        }

        public Builder subscriptionType(String subscriptionType) {
            this.putQueryParameter("SubscriptionType", subscriptionType);
            this.subscriptionType = subscriptionType;
            return this;
        }

        public ReleaseInstanceRequest build() {
            return new ReleaseInstanceRequest(this);
        }
    }
}

