/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class RenewChangeInstanceRequest
extends Request {
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="Parameter")
    private List<Parameter> parameter;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;
    @Query
    @NameInMap(value="ProductType")
    private String productType;
    @Query
    @NameInMap(value="RenewPeriod")
    @Validation(required=true)
    private Long renewPeriod;

    private RenewChangeInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clientToken = builder.clientToken;
        this.instanceId = builder.instanceId;
        this.ownerId = builder.ownerId;
        this.parameter = builder.parameter;
        this.productCode = builder.productCode;
        this.productType = builder.productType;
        this.renewPeriod = builder.renewPeriod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RenewChangeInstanceRequest create() {
        return RenewChangeInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public Long getRenewPeriod() {
        return this.renewPeriod;
    }

    public static class Parameter
    extends TeaModel {
        @NameInMap(value="Code")
        @Validation(required=true)
        private String code;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private Parameter(Builder builder) {
            this.code = builder.code;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Parameter create() {
            return Parameter.builder().build();
        }

        public String getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String code;
            private String value;

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Parameter build() {
                return new Parameter(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<RenewChangeInstanceRequest, Builder> {
        private String clientToken;
        private String instanceId;
        private Long ownerId;
        private List<Parameter> parameter;
        private String productCode;
        private String productType;
        private Long renewPeriod;

        private Builder() {
        }

        private Builder(RenewChangeInstanceRequest request) {
            super((Request)request);
            this.clientToken = request.clientToken;
            this.instanceId = request.instanceId;
            this.ownerId = request.ownerId;
            this.parameter = request.parameter;
            this.productCode = request.productCode;
            this.productType = request.productType;
            this.renewPeriod = request.renewPeriod;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder parameter(List<Parameter> parameter) {
            this.putQueryParameter("Parameter", parameter);
            this.parameter = parameter;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public Builder productType(String productType) {
            this.putQueryParameter("ProductType", productType);
            this.productType = productType;
            return this;
        }

        public Builder renewPeriod(Long renewPeriod) {
            this.putQueryParameter("RenewPeriod", renewPeriod);
            this.renewPeriod = renewPeriod;
            return this;
        }

        public RenewChangeInstanceRequest build() {
            return new RenewChangeInstanceRequest(this);
        }
    }
}

