package com.aliyun.dashvector.models;

import com.aliyun.dashvector.proto.StatsCollectionResponse;
import java.util.HashMap;
import java.util.Map;
import lombok.Getter;

/**
 * @author sanyi
 */
@Getter
public class CollectionStats {
  private final long totalDocCount;
  private final float indexCompleteness;
  private final Map<String, PartitionStats> partitions;

  public CollectionStats(StatsCollectionResponse.CollectionStats collectionStats) {
    this.totalDocCount = collectionStats.getTotalDocCount();
    this.indexCompleteness = collectionStats.getIndexCompleteness();
    this.partitions = new HashMap<>();
    collectionStats
        .getPartitionsMap()
        .forEach((key, value) -> this.partitions.put(key, new PartitionStats(value)));
  }
}
