package com.aliyun.dashvector.models;

import com.aliyun.dashvector.utils.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * @author sanyi
 * @since 2024/1/25 19:50
 */
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DocOpResult implements Serializable {
  @JsonProperty("doc_op")
  private com.aliyun.dashvector.proto.DocOpResult.DocOp docOp;

  private String id;
  private int code;
  private String message;

  public DocOpResult(com.aliyun.dashvector.proto.DocOpResult docOpResult) {
    this.docOp = docOpResult.getDocOp();
    this.id = docOpResult.getId();
    this.code = docOpResult.getCode();
    this.message = docOpResult.getMessage();
  }

  @Override
  public String toString() {
    return Utils.toString(this);
  }
}
