package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.VectorParam;
import com.aliyun.dashvector.proto.CollectionInfo;
import com.aliyun.dashvector.proto.FieldType;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.aliyun.dashvector.validator.ValidatorFactory;
import lombok.*;
import org.apache.commons.collections.MapUtils;

/**
 * @author sanyi
 */
@Getter
@Builder
public class CreateCollectionRequest {
  @NonNull private String name;
  private int dimension;

  @Builder.Default @NonNull
  private CollectionInfo.DataType dataType = CollectionInfo.DataType.FLOAT;

  @Builder.Default @NonNull private CollectionInfo.Metric metric = CollectionInfo.Metric.cosine;

  @Singular("filedSchema")
  private Map<String, FieldType> filedsSchema;

  @Builder.Default private Map<String, String> extraParams = new HashMap<>();
  private Integer timeout;

  @Singular("vectors")
  private Map<String, VectorParam> vectors;
  private VectorParam vectorParam;

  @Singular("sparseVectors")
  private Map<String, VectorParam> sparseVectors;

  public com.aliyun.dashvector.proto.CreateCollectionRequest toProto() throws DashVectorException {
    // validate
    ValidatorFactory.create(this).validate();

    // convert
    com.aliyun.dashvector.proto.CreateCollectionRequest.Builder builder =
        com.aliyun.dashvector.proto.CreateCollectionRequest.newBuilder()
            .setName(name)
            .setDimension(dimension)
            .setDtype(dataType)
            .setMetric(metric);
    // convert dense
    if (MapUtils.isNotEmpty(vectors)) {
      vectors.forEach((k, v) -> builder.putVectorsSchema(k, Convertor.toVectorParam(v)));
    } else if (Objects.nonNull(vectorParam)) {
      builder.putVectorsSchema("", Convertor.toVectorParam(vectorParam));
    }
    // convert sparse
    if (MapUtils.isNotEmpty(sparseVectors)) {
      sparseVectors.forEach((k, v) -> builder.putSparseVectorsSchema(k, Convertor.toVectorParam(v)));
    }
    // convert fields
    if (MapUtils.isNotEmpty(filedsSchema)) {
      builder.putAllFieldsSchema(Convertor.toFieldsSchema(filedsSchema));
    }
    // convert extra params
    if (MapUtils.isNotEmpty(extraParams)) {
      builder.putAllExtraParams(extraParams);
    }

    com.aliyun.dashvector.proto.CreateCollectionRequest request = builder.build();
    Validator.verifyRequestSize(request);
    return request;
  }

}
