package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.Constants;
import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.utils.Validator;
import java.util.List;
import java.util.Objects;
import lombok.*;

/**
 * @author sanyi
 */
@Getter
@Builder
public class DeleteDocRequest {
  @Singular private List<String> ids;
  @Builder.Default @NonNull private String partition = Constants.DEFAULT_PARTITION_NAME;
  @Builder.Default @NonNull private Boolean deleteAll = false;
  private String filter;

  public com.aliyun.dashvector.proto.DeleteDocRequest toProto() throws DashVectorException {
    verify();
    com.aliyun.dashvector.proto.DeleteDocRequest.Builder builder =
        com.aliyun.dashvector.proto.DeleteDocRequest.newBuilder();
    builder.addAllIds(ids);
    builder.setPartition(partition);
    builder.setDeleteAll(deleteAll);
    if (Objects.nonNull(filter)) {
      builder.setFilter(filter);
    }
    com.aliyun.dashvector.proto.DeleteDocRequest request = builder.build();
    Validator.verifyRequestSize(request);
    return request;
  }

  private void verify() throws DashVectorException {
    if (deleteAll && !ids.isEmpty()) {
      throw new DashVectorException(
          ErrorCode.INVALID_PRIMARY_KEY.getCode(),
          "DashVectorSDK DeleteDocRequest ids list must be empty when setting delete_all is true");
    }
    if (!deleteAll) {
      Validator.verifyDocIdList(ids);
    }
    Validator.verifyPartitionName(partition);
    Validator.verifyFilter(filter);
  }
}
