package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.Constants;
import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Vector;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import lombok.Singular;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author jiliang.ljl
 */
@Getter
@Builder
public class QueryDocGroupByRequest {
  private Vector vector;
  private String id;
  @Builder.Default private int groupTopk = 1;
  @Builder.Default private int groupCount = 10;
  @NonNull private String groupByField;
  @Builder.Default private boolean includeVector = false;
  @Builder.Default @NonNull private String partition = Constants.DEFAULT_PARTITION_NAME;
  private String filter;
  @Singular private List<String> outputFields;
  private Map<Long, Float> sparseVector;
  private String vectorField;

  public com.aliyun.dashvector.proto.QueryDocGroupByRequest toProto(CollectionMeta collectionMeta)
      throws DashVectorException {
    // validate
    ValidatorFactory.create(collectionMeta).validateQueryDocGroupByRequest(this);

    // convertor to protobuf
    com.aliyun.dashvector.proto.QueryDocGroupByRequest.Builder builder =
        com.aliyun.dashvector.proto.QueryDocGroupByRequest.newBuilder()
            .setGroupTopk(groupTopk)
            .setGroupCount(groupCount)
            .setGroupByField(groupByField)
            .setPartition(partition)
            .setIncludeVector(includeVector);
    if (Objects.nonNull(id)) {
      builder.setId(id);
    } else if (Objects.nonNull(vector)) {
      if (Objects.nonNull(vectorField)) {
        builder.setVectorField(vectorField);
        builder.setVector(Convertor.toVector(vector.getValue(), collectionMeta.getDataType(vectorField)));
      } else {
        builder.setVector(Convertor.toVector(vector.getValue(), collectionMeta.getDataType()));
      }
    }
    if (Objects.nonNull(outputFields)) {
      builder.addAllOutputFields(outputFields);
    }
    if (Objects.nonNull(sparseVector)) {
      builder.putAllSparseVector(Convertor.toDashVectorSparse(sparseVector));
    }
    if (Objects.nonNull(filter)) {
      builder.setFilter(filter);
    }
    com.aliyun.dashvector.proto.QueryDocGroupByRequest request = builder.build();
    Validator.verifyRequestSize(request);
    return request;
  }
}
