package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.utils.Convertor;
import java.util.stream.Collectors;
import lombok.experimental.SuperBuilder;

/**
 * @author sanyi
 */
@SuperBuilder
public class UpdateDocRequest
    extends WriteDocRequest<com.aliyun.dashvector.proto.UpdateDocRequest> {
  @Override
  protected com.aliyun.dashvector.proto.UpdateDocRequest build(CollectionMeta collectionMeta) {
    return com.aliyun.dashvector.proto.UpdateDocRequest.newBuilder()
        .addAllDocs(
            docs.stream().map(doc -> Convertor.toDoc(doc, collectionMeta)).collect(Collectors.toList()))
        .setPartition(partition)
        .build();
  }
}
