/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector;

import com.aliyun.dashvector.DashVectorClientConfig;
import com.aliyun.dashvector.DashVectorCollection;
import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.requests.CreateCollectionRequest;
import com.aliyun.dashvector.models.responses.Response;
import com.aliyun.dashvector.proto.CreateCollectionResponse;
import com.aliyun.dashvector.proto.DashVectorServiceGrpc;
import com.aliyun.dashvector.proto.DeleteCollectionRequest;
import com.aliyun.dashvector.proto.DeleteCollectionResponse;
import com.aliyun.dashvector.proto.DescribeCollectionRequest;
import com.aliyun.dashvector.proto.DescribeCollectionResponse;
import com.aliyun.dashvector.proto.GetVersionRequest;
import com.aliyun.dashvector.proto.GetVersionResponse;
import com.aliyun.dashvector.proto.ListCollectionsRequest;
import com.aliyun.dashvector.proto.ListCollectionsResponse;
import com.aliyun.dashvector.shaded.io.grpc.CallOptions;
import com.aliyun.dashvector.shaded.io.grpc.Channel;
import com.aliyun.dashvector.shaded.io.grpc.ClientCall;
import com.aliyun.dashvector.shaded.io.grpc.ClientInterceptor;
import com.aliyun.dashvector.shaded.io.grpc.ManagedChannel;
import com.aliyun.dashvector.shaded.io.grpc.ManagedChannelBuilder;
import com.aliyun.dashvector.shaded.io.grpc.Metadata;
import com.aliyun.dashvector.shaded.io.grpc.MethodDescriptor;
import com.aliyun.dashvector.shaded.io.grpc.StatusRuntimeException;
import com.aliyun.dashvector.shaded.io.grpc.stub.MetadataUtils;
import com.aliyun.dashvector.utils.Utils;
import com.aliyun.dashvector.utils.Validator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashVectorClient {
    private static final Logger logger = LoggerFactory.getLogger(DashVectorClient.class);
    @NonNull
    private final DashVectorClientConfig config;
    private final DashVectorServiceGrpc.DashVectorServiceFutureStub stub;
    private final ManagedChannel channel;
    private final ConcurrentHashMap<String, DashVectorCollection> cache;

    public DashVectorClient(@NonNull String apiKey, @NonNull String endpoint) throws DashVectorException {
        this(DashVectorClientConfig.builder().apiKey(apiKey).endpoint(endpoint).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
    }

    public DashVectorClient(@NonNull DashVectorClientConfig config) throws DashVectorException {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        TimeoutInterceptor timeoutInterceptor = new TimeoutInterceptor(config.getTimeout().longValue());
        String endpoint = config.getEndpoint();
        if (!Validator.verifyEndpoint(endpoint)) {
            throw new DashVectorException(ErrorCode.INVALID_ENDPOINT);
        }
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of("dashvector-auth-token", Metadata.ASCII_STRING_MARSHALLER), config.getApiKey());
        metadata.put(Metadata.Key.of("x-user-agent", Metadata.ASCII_STRING_MARSHALLER), Utils.getUserAgent());
        Object builder = ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(endpoint).usePlaintext()).intercept(MetadataUtils.newAttachHeadersInterceptor(metadata), timeoutInterceptor)).maxInboundMessageSize(0x8000000);
        if (!Utils.isInSecureMode()) {
            ((ManagedChannelBuilder)builder).useTransportSecurity();
        }
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)builder).keepAliveTime(1L, TimeUnit.MINUTES)).build();
        this.stub = DashVectorServiceGrpc.newFutureStub(((ManagedChannelBuilder)builder).build());
        this.cache = new ConcurrentHashMap();
        try {
            GetVersionResponse request = (GetVersionResponse)this.stub.getVersion(GetVersionRequest.getDefaultInstance()).get();
            if (request.getCode() != ErrorCode.SUCCESS.getCode()) {
                throw new DashVectorException(request.getCode(), String.format("DashVectorSDK client init failed. Reason: %s. RequestId: %s.", request.getMessage(), request.getRequestId()));
            }
            logger.info("DashVector service version is " + request.getVersion());
        }
        catch (DashVectorException e) {
            throw e;
        }
        catch (StatusRuntimeException e) {
            throw new DashVectorException(e, e.getStatus().getCode().value());
        }
        catch (Exception e) {
            throw new DashVectorException(e, ErrorCode.UNKNOWN.getCode());
        }
    }

    public Response<Void> create(@NonNull String name, int dimension) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        CreateCollectionRequest request = CreateCollectionRequest.builder().name(name).dimension(dimension).build();
        return this.create(request);
    }

    public Response<Void> create(@NonNull CreateCollectionRequest request) {
        CreateCollectionResponse createCollectionResponse;
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Integer timeout = request.getTimeout();
        try {
            createCollectionResponse = (CreateCollectionResponse)this.stub.createCollection(request.toProto()).get();
            if (createCollectionResponse.getCode() != ErrorCode.SUCCESS.getCode() && Objects.isNull(timeout)) {
                return Response.create(createCollectionResponse.getCode(), createCollectionResponse.getMessage(), createCollectionResponse.getRequestId(), null);
            }
        }
        catch (Exception e) {
            return Response.failed(e);
        }
        String collectionName = request.getName();
        int createTimeout = Objects.isNull(timeout) ? 0 : timeout;
        int retryCount = 0;
        do {
            Response<CollectionMeta> describeResponse;
            if ((describeResponse = this.describe(collectionName)).getCode() == ErrorCode.SUCCESS.getCode()) {
                String status = describeResponse.getOutput().getStatus();
                if ("ERROR".equals(status) || "DROPPING".equals(status)) {
                    return Response.create(describeResponse.getCode(), String.format("DashVectorSDK DashVectorCollection(%s) unready. Status is %s ", collectionName, status), describeResponse.getRequestId(), null);
                }
                if ("SERVING".equals(status)) {
                    return Response.success(createCollectionResponse.getCode(), createCollectionResponse.getMessage(), createCollectionResponse.getRequestId());
                }
            } else {
                ++retryCount;
            }
            if (retryCount > 3) {
                return Response.create(describeResponse.getCode(), String.format("DashVectorSDK Get DashVectorCollection(%s) Status create", collectionName), null, null);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                return Response.failed(e);
            }
        } while (Objects.isNull(timeout) || (createTimeout -= 5) >= 0);
        return Response.create(ErrorCode.TIMEOUT.getCode(), String.format("DashVectorSDK Get DashVectorCollection(%s) Status Timeout.", collectionName), null, null);
    }

    public Response<List<String>> list() {
        try {
            ListCollectionsResponse response = (ListCollectionsResponse)this.stub.listCollections(ListCollectionsRequest.getDefaultInstance()).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public Response<CollectionMeta> describe(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        try {
            Validator.verifyCollectionName(name);
            DescribeCollectionRequest req = DescribeCollectionRequest.newBuilder().setName(name).build();
            DescribeCollectionResponse response = (DescribeCollectionResponse)this.stub.describeCollection(req).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public Response<Void> delete(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        try {
            Validator.verifyCollectionName(name);
            DeleteCollectionRequest request = DeleteCollectionRequest.newBuilder().setName(name).build();
            DeleteCollectionResponse response = (DeleteCollectionResponse)this.stub.deleteCollection(request).get();
            if (response.getCode() == ErrorCode.SUCCESS.getCode()) {
                this.cache.remove(name);
            }
            return Response.success(response.getCode(), response.getMessage(), response.getRequestId());
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public DashVectorCollection get(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        Response<CollectionMeta> response = this.describe(name);
        DashVectorCollection dashVectorCollection = new DashVectorCollection(response, this.stub);
        if (dashVectorCollection.isSuccess().booleanValue()) {
            this.cache.put(name, dashVectorCollection);
        }
        return dashVectorCollection;
    }

    public void close() {
        logger.info("DashVectorSDK closed.");
        this.channel.shutdownNow();
    }

    @NonNull
    public DashVectorClientConfig getConfig() {
        return this.config;
    }

    private static class TimeoutInterceptor
    implements ClientInterceptor {
        private final long timeoutSeconds;

        TimeoutInterceptor(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return next.newCall(method, callOptions.withDeadlineAfter(this.timeoutSeconds, TimeUnit.SECONDS));
        }
    }
}

