/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.proto.DeleteDocRequest;
import com.aliyun.dashvector.utils.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;

public class DeleteDocRequest {
    private List<String> ids;
    @NonNull
    private String partition;
    @NonNull
    private Boolean deleteAll;
    private String filter;

    public com.aliyun.dashvector.proto.DeleteDocRequest toProto() throws DashVectorException {
        this.verify();
        DeleteDocRequest.Builder builder = com.aliyun.dashvector.proto.DeleteDocRequest.newBuilder();
        builder.addAllIds(this.ids);
        builder.setPartition(this.partition);
        builder.setDeleteAll(this.deleteAll);
        if (Objects.nonNull(this.filter)) {
            builder.setFilter(this.filter);
        }
        com.aliyun.dashvector.proto.DeleteDocRequest request = builder.build();
        Validator.verifyRequestSize(request);
        return request;
    }

    private void verify() throws DashVectorException {
        if (this.deleteAll.booleanValue() && !this.ids.isEmpty()) {
            throw new DashVectorException(ErrorCode.INVALID_PRIMARY_KEY.getCode(), "DashVectorSDK DeleteDocRequest ids list must be empty when setting delete_all is true");
        }
        if (!this.deleteAll.booleanValue()) {
            Validator.verifyDocIdList(this.ids);
        }
        Validator.verifyPartitionName(this.partition);
        Validator.verifyFilter(this.filter);
    }

    private static String $default$partition() {
        return "default";
    }

    private static Boolean $default$deleteAll() {
        return false;
    }

    DeleteDocRequest(List<String> ids, @NonNull String partition, @NonNull Boolean deleteAll, String filter) {
        if (partition == null) {
            throw new NullPointerException("partition is marked non-null but is null");
        }
        if (deleteAll == null) {
            throw new NullPointerException("deleteAll is marked non-null but is null");
        }
        this.ids = ids;
        this.partition = partition;
        this.deleteAll = deleteAll;
        this.filter = filter;
    }

    public static DeleteDocRequestBuilder builder() {
        return new DeleteDocRequestBuilder();
    }

    public List<String> getIds() {
        return this.ids;
    }

    @NonNull
    public String getPartition() {
        return this.partition;
    }

    @NonNull
    public Boolean getDeleteAll() {
        return this.deleteAll;
    }

    public String getFilter() {
        return this.filter;
    }

    public static class DeleteDocRequestBuilder {
        private ArrayList<String> ids;
        private boolean partition$set;
        private String partition$value;
        private boolean deleteAll$set;
        private Boolean deleteAll$value;
        private String filter;

        DeleteDocRequestBuilder() {
        }

        public DeleteDocRequestBuilder id(String id) {
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.add(id);
            return this;
        }

        public DeleteDocRequestBuilder ids(Collection<? extends String> ids) {
            if (ids == null) {
                throw new NullPointerException("ids cannot be null");
            }
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.addAll(ids);
            return this;
        }

        public DeleteDocRequestBuilder clearIds() {
            if (this.ids != null) {
                this.ids.clear();
            }
            return this;
        }

        public DeleteDocRequestBuilder partition(@NonNull String partition) {
            if (partition == null) {
                throw new NullPointerException("partition is marked non-null but is null");
            }
            this.partition$value = partition;
            this.partition$set = true;
            return this;
        }

        public DeleteDocRequestBuilder deleteAll(@NonNull Boolean deleteAll) {
            if (deleteAll == null) {
                throw new NullPointerException("deleteAll is marked non-null but is null");
            }
            this.deleteAll$value = deleteAll;
            this.deleteAll$set = true;
            return this;
        }

        public DeleteDocRequestBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public DeleteDocRequest build() {
            List<String> ids;
            switch (this.ids == null ? 0 : this.ids.size()) {
                case 0: {
                    ids = Collections.emptyList();
                    break;
                }
                case 1: {
                    ids = Collections.singletonList(this.ids.get(0));
                    break;
                }
                default: {
                    ids = Collections.unmodifiableList(new ArrayList<String>(this.ids));
                }
            }
            String partition$value = this.partition$value;
            if (!this.partition$set) {
                partition$value = DeleteDocRequest.$default$partition();
            }
            Boolean deleteAll$value = this.deleteAll$value;
            if (!this.deleteAll$set) {
                deleteAll$value = DeleteDocRequest.$default$deleteAll();
            }
            return new DeleteDocRequest(ids, partition$value, deleteAll$value, this.filter);
        }

        public String toString() {
            return "DeleteDocRequest.DeleteDocRequestBuilder(ids=" + this.ids + ", partition$value=" + this.partition$value + ", deleteAll$value=" + this.deleteAll$value + ", filter=" + this.filter + ")";
        }
    }
}

