/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.utils.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class FetchDocRequest {
    private List<String> ids;
    @NonNull
    private String partition;

    public com.aliyun.dashvector.proto.FetchDocRequest toProto() throws DashVectorException {
        this.verify();
        com.aliyun.dashvector.proto.FetchDocRequest request = com.aliyun.dashvector.proto.FetchDocRequest.newBuilder().addAllIds(this.ids).setPartition(this.partition).build();
        Validator.verifyRequestSize(request);
        return request;
    }

    private void verify() throws DashVectorException {
        Validator.verifyDocIdList(this.ids);
        Validator.verifyPartitionName(this.partition);
    }

    private static String $default$partition() {
        return "default";
    }

    FetchDocRequest(List<String> ids, @NonNull String partition) {
        if (partition == null) {
            throw new NullPointerException("partition is marked non-null but is null");
        }
        this.ids = ids;
        this.partition = partition;
    }

    public static FetchDocRequestBuilder builder() {
        return new FetchDocRequestBuilder();
    }

    public List<String> getIds() {
        return this.ids;
    }

    @NonNull
    public String getPartition() {
        return this.partition;
    }

    public static class FetchDocRequestBuilder {
        private ArrayList<String> ids;
        private boolean partition$set;
        private String partition$value;

        FetchDocRequestBuilder() {
        }

        public FetchDocRequestBuilder id(String id) {
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.add(id);
            return this;
        }

        public FetchDocRequestBuilder ids(Collection<? extends String> ids) {
            if (ids == null) {
                throw new NullPointerException("ids cannot be null");
            }
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.addAll(ids);
            return this;
        }

        public FetchDocRequestBuilder clearIds() {
            if (this.ids != null) {
                this.ids.clear();
            }
            return this;
        }

        public FetchDocRequestBuilder partition(@NonNull String partition) {
            if (partition == null) {
                throw new NullPointerException("partition is marked non-null but is null");
            }
            this.partition$value = partition;
            this.partition$set = true;
            return this;
        }

        public FetchDocRequest build() {
            List<String> ids;
            switch (this.ids == null ? 0 : this.ids.size()) {
                case 0: {
                    ids = Collections.emptyList();
                    break;
                }
                case 1: {
                    ids = Collections.singletonList(this.ids.get(0));
                    break;
                }
                default: {
                    ids = Collections.unmodifiableList(new ArrayList<String>(this.ids));
                }
            }
            String partition$value = this.partition$value;
            if (!this.partition$set) {
                partition$value = FetchDocRequest.$default$partition();
            }
            return new FetchDocRequest(ids, partition$value);
        }

        public String toString() {
            return "FetchDocRequest.FetchDocRequestBuilder(ids=" + this.ids + ", partition$value=" + this.partition$value + ")";
        }
    }
}

