/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Vector;
import com.aliyun.dashvector.proto.QueryDocGroupByRequest;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class QueryDocGroupByRequest {
    private Vector vector;
    private String id;
    private int groupTopk;
    private int groupCount;
    @NonNull
    private String groupByField;
    private boolean includeVector;
    @NonNull
    private String partition;
    private String filter;
    private List<String> outputFields;
    private Map<Long, Float> sparseVector;
    private String vectorField;

    public com.aliyun.dashvector.proto.QueryDocGroupByRequest toProto(CollectionMeta collectionMeta) throws DashVectorException {
        ValidatorFactory.create(collectionMeta).validateQueryDocGroupByRequest(this);
        QueryDocGroupByRequest.Builder builder = com.aliyun.dashvector.proto.QueryDocGroupByRequest.newBuilder().setGroupTopk(this.groupTopk).setGroupCount(this.groupCount).setGroupByField(this.groupByField).setPartition(this.partition).setIncludeVector(this.includeVector);
        if (Objects.nonNull(this.id)) {
            builder.setId(this.id);
        } else if (Objects.nonNull(this.vector)) {
            if (Objects.nonNull(this.vectorField)) {
                builder.setVectorField(this.vectorField);
                builder.setVector(Convertor.toVector(this.vector.getValue(), collectionMeta.getDataType(this.vectorField)));
            } else {
                builder.setVector(Convertor.toVector(this.vector.getValue(), collectionMeta.getDataType()));
            }
        }
        if (Objects.nonNull(this.outputFields)) {
            builder.addAllOutputFields(this.outputFields);
        }
        if (Objects.nonNull(this.sparseVector)) {
            builder.putAllSparseVector(Convertor.toDashVectorSparse(this.sparseVector));
        }
        if (Objects.nonNull(this.filter)) {
            builder.setFilter(this.filter);
        }
        com.aliyun.dashvector.proto.QueryDocGroupByRequest request = builder.build();
        Validator.verifyRequestSize(request);
        return request;
    }

    private static int $default$groupTopk() {
        return 1;
    }

    private static int $default$groupCount() {
        return 10;
    }

    private static boolean $default$includeVector() {
        return false;
    }

    private static String $default$partition() {
        return "default";
    }

    QueryDocGroupByRequest(Vector vector, String id, int groupTopk, int groupCount, @NonNull String groupByField, boolean includeVector, @NonNull String partition, String filter, List<String> outputFields, Map<Long, Float> sparseVector, String vectorField) {
        if (groupByField == null) {
            throw new NullPointerException("groupByField is marked non-null but is null");
        }
        if (partition == null) {
            throw new NullPointerException("partition is marked non-null but is null");
        }
        this.vector = vector;
        this.id = id;
        this.groupTopk = groupTopk;
        this.groupCount = groupCount;
        this.groupByField = groupByField;
        this.includeVector = includeVector;
        this.partition = partition;
        this.filter = filter;
        this.outputFields = outputFields;
        this.sparseVector = sparseVector;
        this.vectorField = vectorField;
    }

    public static QueryDocGroupByRequestBuilder builder() {
        return new QueryDocGroupByRequestBuilder();
    }

    public Vector getVector() {
        return this.vector;
    }

    public String getId() {
        return this.id;
    }

    public int getGroupTopk() {
        return this.groupTopk;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    @NonNull
    public String getGroupByField() {
        return this.groupByField;
    }

    public boolean isIncludeVector() {
        return this.includeVector;
    }

    @NonNull
    public String getPartition() {
        return this.partition;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public Map<Long, Float> getSparseVector() {
        return this.sparseVector;
    }

    public String getVectorField() {
        return this.vectorField;
    }

    public static class QueryDocGroupByRequestBuilder {
        private Vector vector;
        private String id;
        private boolean groupTopk$set;
        private int groupTopk$value;
        private boolean groupCount$set;
        private int groupCount$value;
        private String groupByField;
        private boolean includeVector$set;
        private boolean includeVector$value;
        private boolean partition$set;
        private String partition$value;
        private String filter;
        private ArrayList<String> outputFields;
        private Map<Long, Float> sparseVector;
        private String vectorField;

        QueryDocGroupByRequestBuilder() {
        }

        public QueryDocGroupByRequestBuilder vector(Vector vector) {
            this.vector = vector;
            return this;
        }

        public QueryDocGroupByRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public QueryDocGroupByRequestBuilder groupTopk(int groupTopk) {
            this.groupTopk$value = groupTopk;
            this.groupTopk$set = true;
            return this;
        }

        public QueryDocGroupByRequestBuilder groupCount(int groupCount) {
            this.groupCount$value = groupCount;
            this.groupCount$set = true;
            return this;
        }

        public QueryDocGroupByRequestBuilder groupByField(@NonNull String groupByField) {
            if (groupByField == null) {
                throw new NullPointerException("groupByField is marked non-null but is null");
            }
            this.groupByField = groupByField;
            return this;
        }

        public QueryDocGroupByRequestBuilder includeVector(boolean includeVector) {
            this.includeVector$value = includeVector;
            this.includeVector$set = true;
            return this;
        }

        public QueryDocGroupByRequestBuilder partition(@NonNull String partition) {
            if (partition == null) {
                throw new NullPointerException("partition is marked non-null but is null");
            }
            this.partition$value = partition;
            this.partition$set = true;
            return this;
        }

        public QueryDocGroupByRequestBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public QueryDocGroupByRequestBuilder outputField(String outputField) {
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.add(outputField);
            return this;
        }

        public QueryDocGroupByRequestBuilder outputFields(Collection<? extends String> outputFields) {
            if (outputFields == null) {
                throw new NullPointerException("outputFields cannot be null");
            }
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.addAll(outputFields);
            return this;
        }

        public QueryDocGroupByRequestBuilder clearOutputFields() {
            if (this.outputFields != null) {
                this.outputFields.clear();
            }
            return this;
        }

        public QueryDocGroupByRequestBuilder sparseVector(Map<Long, Float> sparseVector) {
            this.sparseVector = sparseVector;
            return this;
        }

        public QueryDocGroupByRequestBuilder vectorField(String vectorField) {
            this.vectorField = vectorField;
            return this;
        }

        public QueryDocGroupByRequest build() {
            List<String> outputFields;
            switch (this.outputFields == null ? 0 : this.outputFields.size()) {
                case 0: {
                    outputFields = Collections.emptyList();
                    break;
                }
                case 1: {
                    outputFields = Collections.singletonList(this.outputFields.get(0));
                    break;
                }
                default: {
                    outputFields = Collections.unmodifiableList(new ArrayList<String>(this.outputFields));
                }
            }
            int groupTopk$value = this.groupTopk$value;
            if (!this.groupTopk$set) {
                groupTopk$value = QueryDocGroupByRequest.$default$groupTopk();
            }
            int groupCount$value = this.groupCount$value;
            if (!this.groupCount$set) {
                groupCount$value = QueryDocGroupByRequest.$default$groupCount();
            }
            boolean includeVector$value = this.includeVector$value;
            if (!this.includeVector$set) {
                includeVector$value = QueryDocGroupByRequest.$default$includeVector();
            }
            String partition$value = this.partition$value;
            if (!this.partition$set) {
                partition$value = QueryDocGroupByRequest.$default$partition();
            }
            return new QueryDocGroupByRequest(this.vector, this.id, groupTopk$value, groupCount$value, this.groupByField, includeVector$value, partition$value, this.filter, outputFields, this.sparseVector, this.vectorField);
        }

        public String toString() {
            return "QueryDocGroupByRequest.QueryDocGroupByRequestBuilder(vector=" + this.vector + ", id=" + this.id + ", groupTopk$value=" + this.groupTopk$value + ", groupCount$value=" + this.groupCount$value + ", groupByField=" + this.groupByField + ", includeVector$value=" + this.includeVector$value + ", partition$value=" + this.partition$value + ", filter=" + this.filter + ", outputFields=" + this.outputFields + ", sparseVector=" + this.sparseVector + ", vectorField=" + this.vectorField + ")";
        }
    }
}

