/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Ranker;
import com.aliyun.dashvector.models.SparseVectorQuery;
import com.aliyun.dashvector.models.Vector;
import com.aliyun.dashvector.models.VectorQuery;
import com.aliyun.dashvector.proto.QueryDocRequest;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryDocRequest {
    private Vector vector;
    private VectorQuery vectorQuery;
    private String id;
    private int topk;
    private boolean includeVector;
    @NonNull
    private String partition;
    private String filter;
    private List<String> outputFields;
    private Map<Long, Float> sparseVector;
    private Map<String, VectorQuery> vectors;
    private Map<String, SparseVectorQuery> sparseVectors;
    private Ranker ranker;

    public com.aliyun.dashvector.proto.QueryDocRequest toProto(CollectionMeta collectionMeta) throws DashVectorException {
        ValidatorFactory.create(collectionMeta).validateQueryDocRequest(this);
        QueryDocRequest.Builder builder = com.aliyun.dashvector.proto.QueryDocRequest.newBuilder().setTopk(this.topk).setPartition(this.partition).setIncludeVector(this.includeVector);
        if (StringUtils.isNotEmpty((CharSequence)this.id)) {
            builder.setId(this.id);
        } else {
            if (MapUtils.isNotEmpty(this.vectors)) {
                this.vectors.forEach((k, v) -> builder.putVectors((String)k, Convertor.toVectorQuery(v, collectionMeta.getDataType((String)k))));
            } else if (Objects.nonNull(this.vectorQuery)) {
                builder.putVectors("", Convertor.toVectorQuery(this.vectorQuery, collectionMeta.getDataType()));
            } else if (Objects.nonNull(this.vector)) {
                builder.setVector(Convertor.toVector(this.vector.getValue(), collectionMeta.getDataType()));
            }
            if (MapUtils.isNotEmpty(this.sparseVectors)) {
                this.sparseVectors.forEach((k, v) -> builder.putSparseVectors((String)k, Convertor.toSparseVectorQuery(v, collectionMeta.getDataType((String)k))));
            } else if (Objects.nonNull(this.sparseVector)) {
                builder.putAllSparseVector(Convertor.toDashVectorSparse(this.sparseVector));
            }
        }
        if (CollectionUtils.isNotEmpty(this.outputFields)) {
            builder.addAllOutputFields(this.outputFields);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.filter)) {
            builder.setFilter(this.filter);
        }
        if (Objects.nonNull(this.ranker)) {
            builder.setRerank(this.ranker.toProto());
        }
        com.aliyun.dashvector.proto.QueryDocRequest request = builder.build();
        Validator.verifyRequestSize(request);
        return request;
    }

    private static int $default$topk() {
        return 10;
    }

    private static boolean $default$includeVector() {
        return false;
    }

    private static String $default$partition() {
        return "default";
    }

    QueryDocRequest(Vector vector, VectorQuery vectorQuery, String id, int topk, boolean includeVector, @NonNull String partition, String filter, List<String> outputFields, Map<Long, Float> sparseVector, Map<String, VectorQuery> vectors, Map<String, SparseVectorQuery> sparseVectors, Ranker ranker) {
        if (partition == null) {
            throw new NullPointerException("partition is marked non-null but is null");
        }
        this.vector = vector;
        this.vectorQuery = vectorQuery;
        this.id = id;
        this.topk = topk;
        this.includeVector = includeVector;
        this.partition = partition;
        this.filter = filter;
        this.outputFields = outputFields;
        this.sparseVector = sparseVector;
        this.vectors = vectors;
        this.sparseVectors = sparseVectors;
        this.ranker = ranker;
    }

    public static QueryDocRequestBuilder builder() {
        return new QueryDocRequestBuilder();
    }

    public Vector getVector() {
        return this.vector;
    }

    public VectorQuery getVectorQuery() {
        return this.vectorQuery;
    }

    public String getId() {
        return this.id;
    }

    public int getTopk() {
        return this.topk;
    }

    public boolean isIncludeVector() {
        return this.includeVector;
    }

    @NonNull
    public String getPartition() {
        return this.partition;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public Map<Long, Float> getSparseVector() {
        return this.sparseVector;
    }

    public Map<String, VectorQuery> getVectors() {
        return this.vectors;
    }

    public Map<String, SparseVectorQuery> getSparseVectors() {
        return this.sparseVectors;
    }

    public Ranker getRanker() {
        return this.ranker;
    }

    public static class QueryDocRequestBuilder {
        private Vector vector;
        private VectorQuery vectorQuery;
        private String id;
        private boolean topk$set;
        private int topk$value;
        private boolean includeVector$set;
        private boolean includeVector$value;
        private boolean partition$set;
        private String partition$value;
        private String filter;
        private ArrayList<String> outputFields;
        private Map<Long, Float> sparseVector;
        private ArrayList<String> vectors$key;
        private ArrayList<VectorQuery> vectors$value;
        private ArrayList<String> sparseVectors$key;
        private ArrayList<SparseVectorQuery> sparseVectors$value;
        private Ranker ranker;

        QueryDocRequestBuilder() {
        }

        public QueryDocRequestBuilder vector(Vector vector) {
            this.vector = vector;
            return this;
        }

        public QueryDocRequestBuilder vectorQuery(VectorQuery vectorQuery) {
            this.vectorQuery = vectorQuery;
            return this;
        }

        public QueryDocRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public QueryDocRequestBuilder topk(int topk) {
            this.topk$value = topk;
            this.topk$set = true;
            return this;
        }

        public QueryDocRequestBuilder includeVector(boolean includeVector) {
            this.includeVector$value = includeVector;
            this.includeVector$set = true;
            return this;
        }

        public QueryDocRequestBuilder partition(@NonNull String partition) {
            if (partition == null) {
                throw new NullPointerException("partition is marked non-null but is null");
            }
            this.partition$value = partition;
            this.partition$set = true;
            return this;
        }

        public QueryDocRequestBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public QueryDocRequestBuilder outputField(String outputField) {
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.add(outputField);
            return this;
        }

        public QueryDocRequestBuilder outputFields(Collection<? extends String> outputFields) {
            if (outputFields == null) {
                throw new NullPointerException("outputFields cannot be null");
            }
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.addAll(outputFields);
            return this;
        }

        public QueryDocRequestBuilder clearOutputFields() {
            if (this.outputFields != null) {
                this.outputFields.clear();
            }
            return this;
        }

        public QueryDocRequestBuilder sparseVector(Map<Long, Float> sparseVector) {
            this.sparseVector = sparseVector;
            return this;
        }

        public QueryDocRequestBuilder vectors(String vectorsKey, VectorQuery vectorsValue) {
            if (this.vectors$key == null) {
                this.vectors$key = new ArrayList();
                this.vectors$value = new ArrayList();
            }
            this.vectors$key.add(vectorsKey);
            this.vectors$value.add(vectorsValue);
            return this;
        }

        public QueryDocRequestBuilder vectors(Map<? extends String, ? extends VectorQuery> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors cannot be null");
            }
            if (this.vectors$key == null) {
                this.vectors$key = new ArrayList();
                this.vectors$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends VectorQuery> $lombokEntry : vectors.entrySet()) {
                this.vectors$key.add($lombokEntry.getKey());
                this.vectors$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public QueryDocRequestBuilder clearVectors() {
            if (this.vectors$key != null) {
                this.vectors$key.clear();
                this.vectors$value.clear();
            }
            return this;
        }

        public QueryDocRequestBuilder sparseVectors(String sparseVectorsKey, SparseVectorQuery sparseVectorsValue) {
            if (this.sparseVectors$key == null) {
                this.sparseVectors$key = new ArrayList();
                this.sparseVectors$value = new ArrayList();
            }
            this.sparseVectors$key.add(sparseVectorsKey);
            this.sparseVectors$value.add(sparseVectorsValue);
            return this;
        }

        public QueryDocRequestBuilder sparseVectors(Map<? extends String, ? extends SparseVectorQuery> sparseVectors) {
            if (sparseVectors == null) {
                throw new NullPointerException("sparseVectors cannot be null");
            }
            if (this.sparseVectors$key == null) {
                this.sparseVectors$key = new ArrayList();
                this.sparseVectors$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends SparseVectorQuery> $lombokEntry : sparseVectors.entrySet()) {
                this.sparseVectors$key.add($lombokEntry.getKey());
                this.sparseVectors$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public QueryDocRequestBuilder clearSparseVectors() {
            if (this.sparseVectors$key != null) {
                this.sparseVectors$key.clear();
                this.sparseVectors$value.clear();
            }
            return this;
        }

        public QueryDocRequestBuilder ranker(Ranker ranker) {
            this.ranker = ranker;
            return this;
        }

        public QueryDocRequest build() {
            Map<Object, Object> sparseVectors;
            Map<Object, Object> vectors;
            List<String> outputFields;
            switch (this.outputFields == null ? 0 : this.outputFields.size()) {
                case 0: {
                    outputFields = Collections.emptyList();
                    break;
                }
                case 1: {
                    outputFields = Collections.singletonList(this.outputFields.get(0));
                    break;
                }
                default: {
                    outputFields = Collections.unmodifiableList(new ArrayList<String>(this.outputFields));
                }
            }
            switch (this.vectors$key == null ? 0 : this.vectors$key.size()) {
                case 0: {
                    vectors = Collections.emptyMap();
                    break;
                }
                case 1: {
                    vectors = Collections.singletonMap(this.vectors$key.get(0), this.vectors$value.get(0));
                    break;
                }
                default: {
                    vectors = new LinkedHashMap(this.vectors$key.size() < 0x40000000 ? 1 + this.vectors$key.size() + (this.vectors$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.vectors$key.size(); ++$i) {
                        vectors.put(this.vectors$key.get($i), this.vectors$value.get($i));
                    }
                    vectors = Collections.unmodifiableMap(vectors);
                }
            }
            switch (this.sparseVectors$key == null ? 0 : this.sparseVectors$key.size()) {
                case 0: {
                    sparseVectors = Collections.emptyMap();
                    break;
                }
                case 1: {
                    sparseVectors = Collections.singletonMap(this.sparseVectors$key.get(0), this.sparseVectors$value.get(0));
                    break;
                }
                default: {
                    sparseVectors = new LinkedHashMap(this.sparseVectors$key.size() < 0x40000000 ? 1 + this.sparseVectors$key.size() + (this.sparseVectors$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.sparseVectors$key.size(); ++$i) {
                        sparseVectors.put(this.sparseVectors$key.get($i), this.sparseVectors$value.get($i));
                    }
                    sparseVectors = Collections.unmodifiableMap(sparseVectors);
                }
            }
            int topk$value = this.topk$value;
            if (!this.topk$set) {
                topk$value = QueryDocRequest.$default$topk();
            }
            boolean includeVector$value = this.includeVector$value;
            if (!this.includeVector$set) {
                includeVector$value = QueryDocRequest.$default$includeVector();
            }
            String partition$value = this.partition$value;
            if (!this.partition$set) {
                partition$value = QueryDocRequest.$default$partition();
            }
            return new QueryDocRequest(this.vector, this.vectorQuery, this.id, topk$value, includeVector$value, partition$value, this.filter, outputFields, this.sparseVector, vectors, sparseVectors, this.ranker);
        }

        public String toString() {
            return "QueryDocRequest.QueryDocRequestBuilder(vector=" + this.vector + ", vectorQuery=" + this.vectorQuery + ", id=" + this.id + ", topk$value=" + this.topk$value + ", includeVector$value=" + this.includeVector$value + ", partition$value=" + this.partition$value + ", filter=" + this.filter + ", outputFields=" + this.outputFields + ", sparseVector=" + this.sparseVector + ", vectors$key=" + this.vectors$key + ", vectors$value=" + this.vectors$value + ", sparseVectors$key=" + this.sparseVectors$key + ", sparseVectors$value=" + this.sparseVectors$value + ", ranker=" + this.ranker + ")";
        }
    }
}

