/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.shaded.com.google.protobuf.Message;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class WriteDocRequest<T extends Message> {
    protected List<Doc> docs;
    protected String partition;

    public final T toProto(CollectionMeta collectionMeta, DocOpResult.DocOp docOp) throws DashVectorException {
        ValidatorFactory.create(collectionMeta).validateWriteDocRequest(this, docOp);
        T request = this.build(collectionMeta);
        Validator.verifyRequestSize(request);
        return request;
    }

    protected abstract T build(CollectionMeta var1);

    private static <T extends Message> String $default$partition() {
        return "default";
    }

    protected WriteDocRequest(WriteDocRequestBuilder<T, ?, ?> b) {
        List<Object> docs;
        switch (((WriteDocRequestBuilder)b).docs == null ? 0 : ((WriteDocRequestBuilder)b).docs.size()) {
            case 0: {
                docs = Collections.emptyList();
                break;
            }
            case 1: {
                docs = Collections.singletonList(((WriteDocRequestBuilder)b).docs.get(0));
                break;
            }
            default: {
                docs = Collections.unmodifiableList(new ArrayList(((WriteDocRequestBuilder)b).docs));
            }
        }
        this.docs = docs;
        this.partition = ((WriteDocRequestBuilder)b).partition$set ? ((WriteDocRequestBuilder)b).partition$value : WriteDocRequest.$default$partition();
    }

    public List<Doc> getDocs() {
        return this.docs;
    }

    public String getPartition() {
        return this.partition;
    }

    public static abstract class WriteDocRequestBuilder<T extends Message, C extends WriteDocRequest<T>, B extends WriteDocRequestBuilder<T, C, B>> {
        private ArrayList<Doc> docs;
        private boolean partition$set;
        private String partition$value;

        protected B $fillValuesFrom(C instance) {
            WriteDocRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T extends Message> void $fillValuesFromInstanceIntoBuilder(WriteDocRequest<T> instance, WriteDocRequestBuilder<T, ?, ?> b) {
            b.docs(instance.docs == null ? Collections.emptyList() : instance.docs);
            b.partition(instance.partition);
        }

        public B doc(Doc doc) {
            if (this.docs == null) {
                this.docs = new ArrayList();
            }
            this.docs.add(doc);
            return this.self();
        }

        public B docs(Collection<? extends Doc> docs) {
            if (docs == null) {
                throw new NullPointerException("docs cannot be null");
            }
            if (this.docs == null) {
                this.docs = new ArrayList();
            }
            this.docs.addAll(docs);
            return this.self();
        }

        public B clearDocs() {
            if (this.docs != null) {
                this.docs.clear();
            }
            return this.self();
        }

        public B partition(String partition) {
            this.partition$value = partition;
            this.partition$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "WriteDocRequest.WriteDocRequestBuilder(docs=" + this.docs + ", partition$value=" + this.partition$value + ")";
        }
    }
}

