/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.responses;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.CollectionStats;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.DocOpResult;
import com.aliyun.dashvector.models.Group;
import com.aliyun.dashvector.models.PartitionStats;
import com.aliyun.dashvector.models.RequestUsage;
import com.aliyun.dashvector.proto.DeleteDocResponse;
import com.aliyun.dashvector.proto.DeletePartitionResponse;
import com.aliyun.dashvector.proto.DescribeCollectionResponse;
import com.aliyun.dashvector.proto.DescribePartitionResponse;
import com.aliyun.dashvector.proto.FetchDocResponse;
import com.aliyun.dashvector.proto.InsertDocResponse;
import com.aliyun.dashvector.proto.ListCollectionsResponse;
import com.aliyun.dashvector.proto.ListPartitionsResponse;
import com.aliyun.dashvector.proto.QueryDocGroupByResponse;
import com.aliyun.dashvector.proto.QueryDocResponse;
import com.aliyun.dashvector.proto.StatsCollectionResponse;
import com.aliyun.dashvector.proto.StatsPartitionResponse;
import com.aliyun.dashvector.proto.Status;
import com.aliyun.dashvector.proto.UpdateDocResponse;
import com.aliyun.dashvector.proto.UpsertDocResponse;
import com.aliyun.dashvector.shaded.io.grpc.Metadata;
import com.aliyun.dashvector.shaded.io.grpc.StatusRuntimeException;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class Response<T>
implements Serializable {
    private final int code;
    private final String message;
    @JsonProperty(value="request_id")
    private final String requestId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final T output;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final RequestUsage usage;
    private static final Metadata.Key<String> EXTRA_CODE_KEY = Metadata.Key.of("extra-code", Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> REQUEST_ID_KEY = Metadata.Key.of("request-id", Metadata.ASCII_STRING_MARSHALLER);

    public String toString() {
        return Utils.toString(this);
    }

    private Response(int code, String message, String requestId, T output) {
        this(code, message, requestId, output, null);
    }

    private Response(int code, String message, String requestId, T output, RequestUsage usage) {
        this.code = code;
        this.message = message;
        this.requestId = requestId;
        this.output = output;
        this.usage = usage;
    }

    @JsonIgnore
    public Boolean isSuccess() {
        return this.code == ErrorCode.SUCCESS.getCode();
    }

    public static <T> Response<T> create(int code, String message, String requestId, T output) {
        return new Response<T>(code, message, requestId, output);
    }

    public static <T> Response<T> create(int code, String message, String requestId, T output, RequestUsage usage) {
        return new Response<T>(code, message, requestId, output, usage);
    }

    public static <T> Response<T> failed(Exception e) {
        if (e instanceof DashVectorException) {
            return Response.handleDashVectorException((DashVectorException)e);
        }
        if (e instanceof ExecutionException) {
            return Response.handleExecutionException((ExecutionException)e);
        }
        return Response.handleOtherException(e);
    }

    private static <T> Response<T> handleDashVectorException(DashVectorException e) {
        return Response.create(e.getCode(), e.getMessage(), null, null);
    }

    private static <T> Response<T> handleExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof StatusRuntimeException) {
            return Response.handleStatusRuntimeException((StatusRuntimeException)cause);
        }
        return Response.handleOtherException(e);
    }

    private static <T> Response<T> handleStatusRuntimeException(StatusRuntimeException e) {
        Metadata trailers = e.getTrailers();
        int code = Optional.ofNullable(trailers).map(trailer -> trailer.get(EXTRA_CODE_KEY)).map(Integer::parseInt).orElse(e.getStatus().getCode().value());
        String requestId = Optional.ofNullable(trailers).map(trailer -> trailer.get(REQUEST_ID_KEY)).orElse("");
        return Response.create(code, e.getStatus().getDescription(), requestId, null);
    }

    private static <T> Response<T> handleOtherException(Exception e) {
        return Response.create(ErrorCode.UNKNOWN.getCode(), e.getMessage(), null, null);
    }

    public static Response<Void> success(int code, String message, String requestId) {
        return Response.create(code, message, requestId, null);
    }

    public static Response<List<String>> success(ListCollectionsResponse response) {
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), response.getOutputList());
    }

    public static Response<CollectionMeta> success(DescribeCollectionResponse response) {
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), new CollectionMeta(response.getOutput()));
    }

    public static Response<List<DocOpResult>> success(InsertDocResponse response) {
        List docOpResults = response.getOutputList().stream().map(DocOpResult::new).collect(Collectors.toList());
        return response.hasUsage() ? Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults, Convertor.toRequestUsage(response.getUsage())) : Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults);
    }

    public static Response<List<DocOpResult>> success(UpsertDocResponse response) {
        List docOpResults = response.getOutputList().stream().map(DocOpResult::new).collect(Collectors.toList());
        return response.hasUsage() ? Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults, Convertor.toRequestUsage(response.getUsage())) : Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults);
    }

    public static Response<List<DocOpResult>> success(UpdateDocResponse response) {
        List docOpResults = response.getOutputList().stream().map(DocOpResult::new).collect(Collectors.toList());
        return response.hasUsage() ? Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults, Convertor.toRequestUsage(response.getUsage())) : Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults);
    }

    public static Response<List<DocOpResult>> success(DeleteDocResponse response) {
        List docOpResults = response.getOutputList().stream().map(DocOpResult::new).collect(Collectors.toList());
        return response.hasUsage() ? Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults, Convertor.toRequestUsage(response.getUsage())) : Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docOpResults);
    }

    public static Response<List<Doc>> success(QueryDocResponse response, CollectionMeta collectionMeta) {
        List docs = response.getOutputList().stream().map(doc -> Convertor.fromDoc(doc, collectionMeta)).collect(Collectors.toList());
        return response.hasUsage() ? Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docs, Convertor.toRequestUsage(response.getUsage())) : Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docs);
    }

    public static Response<List<Group>> success(QueryDocGroupByResponse response, CollectionMeta collectionMeta) {
        List groups = response.getOutputList().stream().map(group -> Convertor.fromGroup(group, collectionMeta)).collect(Collectors.toList());
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), groups);
    }

    public static Response<Map<String, Doc>> success(FetchDocResponse response, CollectionMeta collectionMeta) {
        Map<String, Doc> docMap = response.getOutputMap().values().stream().map(doc -> Convertor.fromDoc(doc, collectionMeta)).collect(Collectors.toMap(Doc::getId, v -> v));
        return response.hasUsage() ? Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docMap, Convertor.toRequestUsage(response.getUsage())) : Response.create(response.getCode(), response.getMessage(), response.getRequestId(), docMap);
    }

    public static Response<CollectionStats> success(StatsCollectionResponse response) {
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), new CollectionStats(response.getOutput()));
    }

    public static Response<Status> success(DescribePartitionResponse response) {
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), response.getOutput());
    }

    public static Response<List<String>> success(ListPartitionsResponse response) {
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), response.getOutputList());
    }

    public static Response<PartitionStats> success(StatsPartitionResponse response) {
        return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), new PartitionStats(response.getOutput()));
    }

    public static Response<Void> success(DeletePartitionResponse response) {
        return new Response<Object>(response.getCode(), response.getMessage(), response.getRequestId(), null);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public T getOutput() {
        return this.output;
    }

    public RequestUsage getUsage() {
        return this.usage;
    }
}

