/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.shaded.io.grpc;

import com.aliyun.dashvector.shaded.io.grpc.CallCredentials;
import com.aliyun.dashvector.shaded.io.grpc.Context;
import com.aliyun.dashvector.shaded.io.grpc.ExperimentalApi;
import com.aliyun.dashvector.shaded.io.grpc.Metadata;
import com.aliyun.dashvector.shaded.io.grpc.Status;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
public final class CompositeCallCredentials
extends CallCredentials {
    private final CallCredentials credentials1;
    private final CallCredentials credentials2;

    public CompositeCallCredentials(CallCredentials creds1, CallCredentials creds2) {
        this.credentials1 = (CallCredentials)Preconditions.checkNotNull((Object)creds1, (Object)"creds1");
        this.credentials2 = (CallCredentials)Preconditions.checkNotNull((Object)creds2, (Object)"creds2");
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        this.credentials1.applyRequestMetadata(requestInfo, appExecutor, new WrappingMetadataApplier(requestInfo, appExecutor, applier, Context.current()));
    }

    @Override
    public void thisUsesUnstableApi() {
    }

    private static final class CombiningMetadataApplier
    extends CallCredentials.MetadataApplier {
        private final CallCredentials.MetadataApplier delegate;
        private final Metadata firstHeaders;

        public CombiningMetadataApplier(CallCredentials.MetadataApplier delegate, Metadata firstHeaders) {
            this.delegate = delegate;
            this.firstHeaders = firstHeaders;
        }

        @Override
        public void apply(Metadata headers) {
            Preconditions.checkNotNull((Object)headers, (Object)"headers");
            Metadata combined = new Metadata();
            combined.merge(this.firstHeaders);
            combined.merge(headers);
            this.delegate.apply(combined);
        }

        @Override
        public void fail(Status status) {
            this.delegate.fail(status);
        }
    }

    private final class WrappingMetadataApplier
    extends CallCredentials.MetadataApplier {
        private final CallCredentials.RequestInfo requestInfo;
        private final Executor appExecutor;
        private final CallCredentials.MetadataApplier delegate;
        private final Context context;

        public WrappingMetadataApplier(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier delegate, Context context) {
            this.requestInfo = requestInfo;
            this.appExecutor = appExecutor;
            this.delegate = (CallCredentials.MetadataApplier)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context");
        }

        @Override
        public void apply(Metadata headers) {
            Preconditions.checkNotNull((Object)headers, (Object)"headers");
            Context previous = this.context.attach();
            try {
                CompositeCallCredentials.this.credentials2.applyRequestMetadata(this.requestInfo, this.appExecutor, new CombiningMetadataApplier(this.delegate, headers));
            }
            finally {
                this.context.detach(previous);
            }
        }

        @Override
        public void fail(Status status) {
            this.delegate.fail(status);
        }
    }
}

