/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.shaded.io.grpc.stub;

import com.aliyun.dashvector.shaded.io.grpc.CallOptions;
import com.aliyun.dashvector.shaded.io.grpc.Channel;
import com.aliyun.dashvector.shaded.io.grpc.ClientCall;
import com.aliyun.dashvector.shaded.io.grpc.ClientInterceptor;
import com.aliyun.dashvector.shaded.io.grpc.ExperimentalApi;
import com.aliyun.dashvector.shaded.io.grpc.ForwardingClientCall;
import com.aliyun.dashvector.shaded.io.grpc.ForwardingClientCallListener;
import com.aliyun.dashvector.shaded.io.grpc.Metadata;
import com.aliyun.dashvector.shaded.io.grpc.MethodDescriptor;
import com.aliyun.dashvector.shaded.io.grpc.Status;
import com.aliyun.dashvector.shaded.io.grpc.stub.AbstractStub;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import java.util.concurrent.atomic.AtomicReference;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1789")
    @InlineMe(replacement="stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(extraHeaders))", imports={"com.aliyun.dashvector.shaded.io.grpc.stub.MetadataUtils"})
    public static <T extends AbstractStub<T>> T attachHeaders(T stub, Metadata extraHeaders) {
        return stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(extraHeaders));
    }

    public static ClientInterceptor newAttachHeadersInterceptor(Metadata extraHeaders) {
        return new HeaderAttachingClientInterceptor(extraHeaders);
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1789")
    @InlineMe(replacement="stub.withInterceptors(MetadataUtils.newCaptureMetadataInterceptor(headersCapture, trailersCapture))", imports={"com.aliyun.dashvector.shaded.io.grpc.stub.MetadataUtils"})
    public static <T extends AbstractStub<T>> T captureMetadata(T stub, AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
        return stub.withInterceptors(MetadataUtils.newCaptureMetadataInterceptor(headersCapture, trailersCapture));
    }

    public static ClientInterceptor newCaptureMetadataInterceptor(AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
        return new MetadataCapturingClientInterceptor(headersCapture, trailersCapture);
    }

    private static final class MetadataCapturingClientInterceptor
    implements ClientInterceptor {
        final AtomicReference<Metadata> headersCapture;
        final AtomicReference<Metadata> trailersCapture;

        MetadataCapturingClientInterceptor(AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
            this.headersCapture = (AtomicReference)Preconditions.checkNotNull(headersCapture, (Object)"headersCapture");
            this.trailersCapture = (AtomicReference)Preconditions.checkNotNull(trailersCapture, (Object)"trailersCapture");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new MetadataCapturingClientCall<ReqT, RespT>(next.newCall(method, callOptions));
        }

        private final class MetadataCapturingClientCall<ReqT, RespT>
        extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
            MetadataCapturingClientCall(ClientCall<ReqT, RespT> call) {
                super(call);
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                MetadataCapturingClientInterceptor.this.headersCapture.set(null);
                MetadataCapturingClientInterceptor.this.trailersCapture.set(null);
                super.start(new MetadataCapturingClientCallListener(responseListener), headers);
            }

            private final class MetadataCapturingClientCallListener
            extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
                MetadataCapturingClientCallListener(ClientCall.Listener<RespT> responseListener) {
                    super(responseListener);
                }

                @Override
                public void onHeaders(Metadata headers) {
                    MetadataCapturingClientInterceptor.this.headersCapture.set(headers);
                    super.onHeaders(headers);
                }

                @Override
                public void onClose(Status status, Metadata trailers) {
                    MetadataCapturingClientInterceptor.this.trailersCapture.set(trailers);
                    super.onClose(status, trailers);
                }
            }
        }
    }

    private static final class HeaderAttachingClientInterceptor
    implements ClientInterceptor {
        private final Metadata extraHeaders;

        HeaderAttachingClientInterceptor(Metadata extraHeaders) {
            this.extraHeaders = (Metadata)Preconditions.checkNotNull((Object)extraHeaders, (Object)"extraHeaders");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new HeaderAttachingClientCall<ReqT, RespT>(next.newCall(method, callOptions));
        }

        private final class HeaderAttachingClientCall<ReqT, RespT>
        extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
            HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
                super(call);
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.merge(HeaderAttachingClientInterceptor.this.extraHeaders);
                super.start(responseListener, headers);
            }
        }
    }
}

