/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.shaded.io.grpc.stub;

import com.aliyun.dashvector.shaded.io.grpc.ExperimentalApi;
import com.aliyun.dashvector.shaded.io.grpc.stub.CallStreamObserver;
import com.google.common.base.Preconditions;
import java.util.Iterator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
public final class StreamObservers {
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, (Object)"source");
        Preconditions.checkNotNull(target, (Object)"target");
        final class FlowControllingOnReadyHandler
        implements Runnable {
            private boolean completed;

            FlowControllingOnReadyHandler() {
            }

            @Override
            public void run() {
                if (this.completed) {
                    return;
                }
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    this.completed = true;
                    target.onCompleted();
                }
            }
        }
        target.setOnReadyHandler(new FlowControllingOnReadyHandler());
    }

    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, (Object)"source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

