/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.utils;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.Group;
import com.aliyun.dashvector.models.RequestUsage;
import com.aliyun.dashvector.models.SparseVector;
import com.aliyun.dashvector.models.Vector;
import com.aliyun.dashvector.models.VectorParam;
import com.aliyun.dashvector.models.VectorQuery;
import com.aliyun.dashvector.proto.CollectionInfo;
import com.aliyun.dashvector.proto.Doc;
import com.aliyun.dashvector.proto.FieldType;
import com.aliyun.dashvector.proto.FieldValue;
import com.aliyun.dashvector.proto.GroupResult;
import com.aliyun.dashvector.proto.RequestUsage;
import com.aliyun.dashvector.proto.SparseVector;
import com.aliyun.dashvector.proto.SparseVectorQuery;
import com.aliyun.dashvector.proto.Vector;
import com.aliyun.dashvector.proto.VectorQueryParam;
import com.aliyun.dashvector.shaded.com.google.protobuf.ByteString;
import com.google.common.primitives.Floats;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class Convertor {
    public static Doc toDoc(@NonNull com.aliyun.dashvector.models.Doc doc, CollectionMeta collectionMeta) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        Doc.Builder builder = Doc.newBuilder().setScore(doc.getScore());
        if (MapUtils.isNotEmpty(doc.getVectors())) {
            doc.getVectors().forEach((k, v) -> builder.putVectors((String)k, Convertor.toVector(v.getValue(), collectionMeta.getDataType((String)k))));
        } else if (Objects.nonNull(doc.getVector())) {
            builder.setVector(Convertor.toVector(doc.getVector().getValue(), collectionMeta.getDataType()));
        }
        if (MapUtils.isNotEmpty(doc.getSparseVectors())) {
            doc.getSparseVectors().forEach((k, v) -> builder.putSparseVectors((String)k, Convertor.toDashSparseVector(v)));
        } else if (MapUtils.isNotEmpty(doc.getSparseVector())) {
            builder.putAllSparseVector(Convertor.toDashVectorSparse(doc.getSparseVector()));
        }
        if (StringUtils.isNotEmpty((CharSequence)doc.getId())) {
            builder.setId(doc.getId());
        }
        if (MapUtils.isNotEmpty(doc.getFields())) {
            builder.putAllFields(Convertor.toFieldMap(doc.getFields()));
        }
        return builder.build();
    }

    public static com.aliyun.dashvector.models.Doc fromDoc(@NonNull Doc doc, @NonNull CollectionMeta collectionMeta) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        if (collectionMeta == null) {
            throw new NullPointerException("collectionMeta is marked non-null but is null");
        }
        Doc.DocBuilder builder = com.aliyun.dashvector.models.Doc.builder().id(doc.getId()).fields(Convertor.fromFieldMap(doc.getFieldsMap())).score(doc.getScore());
        if (MapUtils.isNotEmpty(doc.getVectorsMap())) {
            HashMap vectors = new HashMap();
            doc.getVectorsMap().forEach((k, v) -> vectors.put(k, Convertor.fromVector(v, collectionMeta.getVectors().get(k).getDataType())));
            builder.vectors(vectors);
        } else if (doc.hasVector()) {
            builder.vector(Convertor.fromVector(doc.getVector(), collectionMeta.getDataType()));
        }
        if (MapUtils.isNotEmpty(doc.getSparseVectorsMap())) {
            doc.getSparseVectorsMap().forEach((k, v) -> builder.sparseVectors((String)k, Convertor.fromDashVectorSparse(v)));
        } else if (MapUtils.isNotEmpty(doc.getSparseVectorMap())) {
            builder.sparseVector(Convertor.fromDashVectorSparse(doc.getSparseVectorMap()));
        }
        return builder.build();
    }

    public static com.aliyun.dashvector.proto.Vector toVector(@NonNull List<? extends Number> input, @NonNull CollectionInfo.DataType dataType) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (dataType == CollectionInfo.DataType.INT) {
            ByteBuffer buffer = ByteBuffer.allocate(input.size()).order(ByteOrder.LITTLE_ENDIAN);
            input.forEach(e -> buffer.put(e.byteValue()));
            return com.aliyun.dashvector.proto.Vector.newBuilder().setByteVector(ByteString.copyFrom(buffer.array())).build();
        }
        return com.aliyun.dashvector.proto.Vector.newBuilder().setFloatVector(Vector.FloatVector.newBuilder().addAllValues(Floats.asList((float[])Floats.toArray(input)))).build();
    }

    public static Vector fromVector(@NonNull com.aliyun.dashvector.proto.Vector vector, @NonNull CollectionInfo.DataType dataType) {
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (dataType == CollectionInfo.DataType.INT) {
            ArrayList<Integer> integerList = new ArrayList<Integer>();
            ByteBuffer buffer = ByteBuffer.wrap(vector.getByteVector().toByteArray()).order(ByteOrder.LITTLE_ENDIAN);
            while (buffer.hasRemaining()) {
                integerList.add(Integer.valueOf(buffer.get()));
            }
            return Vector.builder().value(integerList).build();
        }
        return Vector.builder().value(vector.getFloatVector().getValuesList()).build();
    }

    public static Map<String, FieldValue> toFieldMap(@NonNull Map<String, Object> fieldMap) {
        if (fieldMap == null) {
            throw new NullPointerException("fieldMap is marked non-null but is null");
        }
        HashMap<String, FieldValue> field = new HashMap<String, FieldValue>();
        for (String key : fieldMap.keySet()) {
            Object value = fieldMap.get(key);
            if (value == null) continue;
            if (value instanceof Integer) {
                field.put(key, FieldValue.newBuilder().setIntValue((Integer)value).build());
                continue;
            }
            if (value instanceof Float) {
                field.put(key, FieldValue.newBuilder().setFloatValue(((Float)value).floatValue()).build());
                continue;
            }
            if (value instanceof String) {
                field.put(key, FieldValue.newBuilder().setStringValue((String)value).build());
                continue;
            }
            if (value instanceof Boolean) {
                field.put(key, FieldValue.newBuilder().setBoolValue((Boolean)value).build());
                continue;
            }
            if (value instanceof Long) {
                field.put(key, FieldValue.newBuilder().setLongValue((Long)value).build());
                continue;
            }
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), String.format("DashVectorSDK does not support input field value[%s] and must be in [bool, str, int, float, long]", value));
        }
        return field;
    }

    public static Map<String, Object> fromFieldMap(@NonNull Map<String, FieldValue> fieldMap) {
        if (fieldMap == null) {
            throw new NullPointerException("fieldMap is marked non-null but is null");
        }
        HashMap<String, Object> field = new HashMap<String, Object>();
        block8: for (String key : fieldMap.keySet()) {
            FieldValue value = fieldMap.get(key);
            switch (value.getValueOneofCase()) {
                case INT_VALUE: {
                    field.put(key, value.getIntValue());
                    continue block8;
                }
                case BOOL_VALUE: {
                    field.put(key, value.getBoolValue());
                    continue block8;
                }
                case FLOAT_VALUE: {
                    field.put(key, Float.valueOf(value.getFloatValue()));
                    continue block8;
                }
                case STRING_VALUE: {
                    field.put(key, value.getStringValue());
                    continue block8;
                }
                case LONG_VALUE: {
                    field.put(key, value.getLongValue());
                    continue block8;
                }
                case VALUEONEOF_NOT_SET: {
                    continue block8;
                }
            }
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), String.format("DashVectorSDK does not support receive field value[%s] and must be in [bool, str, int, float]", value));
        }
        return field;
    }

    public static Map<String, FieldType> toFieldsSchema(@NonNull Map<String, FieldType> fieldsSchema) {
        if (fieldsSchema == null) {
            throw new NullPointerException("fieldsSchema is marked non-null but is null");
        }
        HashMap<String, FieldType> schema = new HashMap<String, FieldType>();
        for (String key : fieldsSchema.keySet()) {
            FieldType fieldType = fieldsSchema.get(key);
            schema.put(key, FieldType.valueOf(fieldType.name()));
        }
        return schema;
    }

    public static Map<Integer, Float> toDashVectorSparse(Map<Long, Float> sparseVector) {
        TreeMap<Long, Float> sortedMap = new TreeMap<Long, Float>(sparseVector);
        return sortedMap.entrySet().stream().collect(Collectors.toMap(entry -> ((Long)entry.getKey()).intValue(), Map.Entry::getValue));
    }

    public static Map<Long, Float> fromDashVectorSparse(Map<Integer, Float> sparseVector) {
        return sparseVector.entrySet().stream().collect(Collectors.toMap(entry -> Integer.toUnsignedLong((Integer)entry.getKey()), Map.Entry::getValue));
    }

    public static Group fromGroup(GroupResult group, CollectionMeta collectionMeta) {
        return Group.builder().groupId(group.getGroupId()).docs(group.getDocsList().stream().map(doc -> Convertor.fromDoc(doc, collectionMeta)).collect(Collectors.toList())).build();
    }

    public static com.aliyun.dashvector.models.RequestUsage toRequestUsage(@NonNull RequestUsage usage) {
        if (usage == null) {
            throw new NullPointerException("usage is marked non-null but is null");
        }
        RequestUsage.RequestUsageBuilder builder = com.aliyun.dashvector.models.RequestUsage.builder();
        if (usage.hasReadUnits()) {
            return builder.readUnits(usage.getReadUnits()).build();
        }
        if (usage.hasWriteUnits()) {
            return builder.writeUnits(usage.getWriteUnits()).build();
        }
        throw new DashVectorException(ErrorCode.UNKNOWN.getCode(), String.format("DashVectorSDK get wrong upper stream usage response, empty read_units and write_units field", new Object[0]));
    }

    public static com.aliyun.dashvector.proto.VectorQuery toVectorQuery(VectorQuery query, CollectionInfo.DataType dataType) {
        return com.aliyun.dashvector.proto.VectorQuery.newBuilder().setVector(Convertor.toVector(query.getVector().getValue(), dataType)).setParam(Convertor.toVectorQueryParam(query)).build();
    }

    public static VectorQueryParam toVectorQueryParam(VectorQuery param) {
        return VectorQueryParam.newBuilder().setNumCandidates(param.getNumCandidates()).setRadius(param.getRadius()).setIsLinear(param.isLinear()).setEf(param.getEf()).build();
    }

    public static CollectionInfo.VectorParam toVectorParam(VectorParam param) {
        return CollectionInfo.VectorParam.newBuilder().setDimension(param.getDimension()).setDtype(param.getDataType()).setMetric(param.getMetric()).setQuantizeType(param.getQuantizeType()).build();
    }

    public static VectorParam toVectorParam(CollectionInfo.VectorParam param) {
        return VectorParam.builder().dimension(param.getDimension()).dataType(param.getDtype()).metric(param.getMetric()).quantizeType(param.getQuantizeType()).build();
    }

    public static SparseVectorQuery toSparseVectorQuery(com.aliyun.dashvector.models.SparseVectorQuery query, CollectionInfo.DataType dataType) {
        return SparseVectorQuery.newBuilder().setSparseVector(Convertor.toDashSparseVector(query.getVector())).setParam(Convertor.toSparseVectorQueryParam(query)).build();
    }

    private static com.aliyun.dashvector.proto.SparseVector toDashSparseVector(SparseVector sparseVector) {
        TreeMap<Long, Float> sortedMap = new TreeMap<Long, Float>(sparseVector.getValue());
        SparseVector.Builder builder = com.aliyun.dashvector.proto.SparseVector.newBuilder();
        builder.putAllSparseVector(sortedMap.entrySet().stream().collect(Collectors.toMap(entry -> ((Long)entry.getKey()).intValue(), Map.Entry::getValue)));
        return builder.build();
    }

    private static SparseVector fromDashVectorSparse(com.aliyun.dashvector.proto.SparseVector sparseVector) {
        SparseVector.SparseVectorBuilder builder = SparseVector.builder();
        Map<Long, Float> longFloatMap = sparseVector.getSparseVectorMap().entrySet().stream().collect(Collectors.toMap(entry -> ((Integer)entry.getKey()).longValue(), Map.Entry::getValue));
        return builder.value(longFloatMap).build();
    }

    private static VectorQueryParam toSparseVectorQueryParam(com.aliyun.dashvector.models.SparseVectorQuery param) {
        return VectorQueryParam.newBuilder().setNumCandidates(param.getNumCandidates()).setRadius(param.getRadius()).setIsLinear(param.isLinear()).setEf(param.getEf()).build();
    }
}

