/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.utils;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Objects;
import java.util.Properties;

public class Utils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toString(Object o) throws DashVectorException {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new DashVectorException(ErrorCode.INVALID_JSON.getCode(), String.format("Json serialization failed. exception_msg:%s, object_type:%s", e.getMessage(), o.getClass().getName()));
        }
    }

    public static boolean isInSecureMode() {
        String inSecureMode = System.getenv("DASHVECTOR_INSECURE_MODE");
        if (Objects.isNull(inSecureMode) || inSecureMode.isEmpty()) {
            return false;
        }
        return "1".equalsIgnoreCase(inSecureMode) || "true".equalsIgnoreCase(inSecureMode);
    }

    public static String getSdkVersion() {
        String version = null;
        Properties properties = new Properties();
        try {
            properties.load(Utils.class.getClassLoader().getResourceAsStream("dashvector.properties"));
            if (!properties.isEmpty()) {
                version = properties.getProperty("dashvector.version");
            }
        }
        catch (IOException e) {
            throw new DashVectorException(e, ErrorCode.UNKNOWN.getCode());
        }
        return version;
    }

    public static String getUserAgent() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        return String.format("%s;%s;%s_%s_%s", Utils.getSdkVersion(), System.getProperty("java.version"), osBean.getName(), osBean.getArch(), osBean.getVersion());
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

