/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.utils;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.Vector;
import com.aliyun.dashvector.models.VectorParam;
import com.aliyun.dashvector.proto.CollectionInfo;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.proto.FieldType;
import com.aliyun.dashvector.shaded.com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class Validator {
    public static final String RESERVE_DENSE_VECTOR = "proxima_vector";
    public static final String RESERVE_DENSE_VECTOR_MSG = String.format("DashVectorSDK DashVectorCollection fieldName %s is reserved", "proxima_vector");
    public static final String RESERVE_SPARSE_VECTOR = "proxima_sparse_vector";
    public static final String RESERVE_SPARSE_VECTOR_MSG = String.format("DashVectorSDK DashVectorCollection fieldName %s is reserved", "proxima_sparse_vector");
    private static final int MAX_REQUEST_SIZE = 0x200000;
    private static final String MAX_REQUEST_SIZE_MSG = "DashVectorSDK Request Length(%d) exceeds Maximum Length(2MiB) Limit";
    private static final int MAX_DIMENSION = 20000;
    private static final String DIMENSION_LIMIT_MSG = "DashVectorSDK CreateCollectionRequest dimension Value(%d) is Invalid and must be in (1, 20000]";
    private static final int MAX_BATCH_SIZE = 1024;
    private static final String BATCH_SIZE_LIMIT_MSG = "DashVectorSDK Doc list size must greater than 0, and less than or equal to 1024";
    private static final int MAX_DOCID_SIZE = 1024;
    private static final String DOCID_LIMIT_MSG = "DashVectorSDK Ids list size must greater than 0, and less than or equal to 1024";
    private static final int MAX_TOPK = 1024;
    private static final String TOPK_LIMIT_MSG = "DashVectorSDK TopK(%d) is invalid, and must be in [1, %d] when includeVector is true";
    private static final int MAX_FIELDS_COUNT = 1024;
    private static final String FIELDS_LIMIT_MSG = "DashVectorSDK DashVectorCollection fields size(%d) must less than or equal to 1024";
    public static final int MAX_VECTORS_COUNT = 4;
    private static final String VECTORS_LIMIT_MSG = "DashVectorSDK DashVectorCollection vectors size must less than or equal to 4";
    private static final String INT8_LIMIT_MSG = "DashVectorSDK Receive vector Value(%s) is Invalid and int value must [-128,127]";
    private static final Pattern COLLECTION_AND_PARTITION_NAME_REGEX = Pattern.compile("^[a-zA-Z0-9_-]{3,32}$");
    private static final Pattern FIELD_NAME_REGEX = Pattern.compile("^[a-zA-Z0-9_-]{1,32}$");
    private static final String FIELD_LIMIT_MSG = "DashVectorSDK Receive Request fieldName in fieldsSchema Characters(%s) is Invalid and character must be in [a-zA-Z0-9] and symbols[_, -] and length must be in [1,32]";
    private static final Pattern DOC_ID_REGEX = Pattern.compile("^[a-zA-Z0-9_\\-!@#$%+=.]{1,64}$");
    private static final String COLLECTION_AND_PARTITION_LIMIT_MSG = "DashVectorSDK DashVectorCollection/Partition name[%s] is invalid, must only contains [a-zA-Z0-9_-] with length in [3, 32]";
    private static final String DOC_ID_MSG = "DashVectorSDK Doc id[%s] is invalid, must only contains [a-zA-Z0-9_-] and symbols[_-!@#$+=.] with length in [1, 64]";
    private static final int MAX_FILTER_SIZE = 40960;
    private static final String FILTER_LIMIT_MSG = "DashVectorSDK filter size(%d) must less than or equal to 40960";
    private static final Pattern ENDPOINT_REGEX = Pattern.compile("^(?!-)[a-zA-Z0-9-.]+\\.[a-z.]{2,6}/?$");
    private static final long UINT32_MAXVALUE = (long)Math.pow(2.0, 32.0) - 1L;
    private static final int MAX_GROUP_TOPK = 16;
    private static final String GROUP_TOPK_LIMIT_MSG = "DashVectorSDK GroupTopK(%d) is invalid, and must be in [1, %d] when includeVector is true";
    private static final int MAX_GROUP_COUNT = 64;
    private static final String GROUP_COUNT_LIMIT_MSG = "DashVectorSDK GroupCount(%d) is invalid, and must be in [1, %d] when includeVector is true";

    public static void verifyRequestSize(@NonNull Message message) throws DashVectorException {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (message.getSerializedSize() > 0x200000) {
            throw new DashVectorException(ErrorCode.EXCEED_REQUEST_SIZE.getCode(), String.format(MAX_REQUEST_SIZE_MSG, message.getSerializedSize()));
        }
    }

    public static void verifyDocIdRequireNonEmpty(@NonNull String id) throws DashVectorException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (!DOC_ID_REGEX.matcher(id).find()) {
            throw new DashVectorException(ErrorCode.INVALID_PRIMARY_KEY.getCode(), String.format(DOC_ID_MSG, id));
        }
    }

    public static void verifyDocId(String id) throws DashVectorException {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        Validator.verifyDocIdRequireNonEmpty(id);
    }

    public static void verifyOutputFields(List<String> outputFields) throws DashVectorException {
        if (Objects.isNull(outputFields)) {
            return;
        }
        for (String outputField : outputFields) {
            if (FIELD_NAME_REGEX.matcher(outputField).find()) continue;
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), String.format(FIELD_LIMIT_MSG, outputField));
        }
    }

    public static void verifyTopK(int topk, boolean includeVector) throws DashVectorException {
        if (topk < 1 || topk > 1024 && includeVector) {
            throw new DashVectorException(ErrorCode.INVALID_TOPK.getCode(), String.format(TOPK_LIMIT_MSG, topk, 1024));
        }
    }

    public static void verifyGroupTopK(int groupTopK, boolean includeVector) throws DashVectorException {
        if (groupTopK < 1 || groupTopK > 16 && includeVector) {
            throw new DashVectorException(ErrorCode.INVALID_GROUP_BY.getCode(), String.format(GROUP_TOPK_LIMIT_MSG, groupTopK, 16));
        }
    }

    public static void verifyGroupCount(int groupCount, boolean includeVector) throws DashVectorException {
        if (groupCount < 1 || groupCount > 64 && includeVector) {
            throw new DashVectorException(ErrorCode.INVALID_GROUP_BY.getCode(), String.format(GROUP_COUNT_LIMIT_MSG, groupCount, 64));
        }
    }

    public static void verifyGroupByField(String groupByField) throws DashVectorException {
        if (StringUtils.isEmpty((CharSequence)groupByField)) {
            throw new DashVectorException(ErrorCode.INVALID_GROUP_BY.getCode(), "DashVectorSDK GroupByField is empty");
        }
    }

    public static void verifyBatchSize(List<Doc> docs) throws DashVectorException {
        if (Objects.isNull(docs) || docs.size() > 1024 || docs.isEmpty()) {
            throw new DashVectorException(ErrorCode.INVALID_BATCH_SIZE.getCode(), BATCH_SIZE_LIMIT_MSG);
        }
    }

    public static void verifyCollectionName(@NonNull String name) throws DashVectorException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!COLLECTION_AND_PARTITION_NAME_REGEX.matcher(name).find()) {
            throw new DashVectorException(ErrorCode.INVALID_COLLECTION_NAME.getCode(), String.format(COLLECTION_AND_PARTITION_LIMIT_MSG, name));
        }
    }

    public static void verifyPartitionName(@NonNull String name) throws DashVectorException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!COLLECTION_AND_PARTITION_NAME_REGEX.matcher(name).find()) {
            throw new DashVectorException(ErrorCode.INVALID_PARTITION_NAME.getCode(), String.format(COLLECTION_AND_PARTITION_LIMIT_MSG, name));
        }
    }

    public static void verifyDimension(int dimension) throws DashVectorException {
        if (dimension > 20000 || dimension <= 1) {
            throw new DashVectorException(ErrorCode.INVALID_DIMENSION.getCode(), String.format(DIMENSION_LIMIT_MSG, dimension));
        }
    }

    public static void verifyFields(Map<String, ?> fieldsMap) throws DashVectorException {
        if (MapUtils.isEmpty(fieldsMap)) {
            return;
        }
        if (fieldsMap.size() > 1024) {
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), String.format(FIELDS_LIMIT_MSG, fieldsMap.size()));
        }
        if (fieldsMap.containsKey(RESERVE_DENSE_VECTOR)) {
            throw new DashVectorException(ErrorCode.INVALID_FIELD_NAME.getCode(), RESERVE_DENSE_VECTOR_MSG);
        }
        for (String s : fieldsMap.keySet()) {
            if (FIELD_NAME_REGEX.matcher(s).find()) continue;
            throw new DashVectorException(ErrorCode.INVALID_FIELD_NAME.getCode(), String.format(FIELD_LIMIT_MSG, s));
        }
    }

    public static void verifyFieldsValue(Map<String, ?> fieldsMap, Map<String, FieldType> fieldsScheme) throws DashVectorException {
        Validator.verifyFields(fieldsMap);
        fieldsScheme.forEach((field, type) -> {
            Object value = fieldsMap.get(field);
            if (value == null) {
                return;
            }
            if (type == FieldType.BOOL && value instanceof Boolean || type == FieldType.INT && value instanceof Integer || type == FieldType.LONG && value instanceof Long || type == FieldType.STRING && value instanceof String || type == FieldType.FLOAT && value instanceof Float) {
                return;
            }
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), String.format("The field[%s] value must be %s", field, type.name().toLowerCase()));
        });
    }

    public static void verifyFilter(String filter) throws DashVectorException {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return;
        }
        if (filter.length() > 40960) {
            throw new DashVectorException(ErrorCode.INVALID_FILTER.getCode(), String.format(FILTER_LIMIT_MSG, filter.length()));
        }
    }

    public static void verifyDocIdList(List<String> docIds) throws DashVectorException {
        if (CollectionUtils.isEmpty(docIds) || docIds.size() > 1024) {
            throw new DashVectorException(ErrorCode.EXCEED_IDS_LIMIT.getCode(), DOCID_LIMIT_MSG);
        }
        for (String docId : docIds) {
            Validator.verifyDocIdRequireNonEmpty(docId);
        }
    }

    public static void verifyVector(Vector vector, DocOpResult.DocOp docOp, int dimension) {
        if (Objects.isNull(vector)) {
            if (docOp != DocOpResult.DocOp.update) {
                throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT.getCode(), "DashVectorSDK vector is required when request in [insert, upsert]");
            }
        } else {
            if (vector.getValue().size() != dimension) {
                throw new DashVectorException(ErrorCode.MISMATCHED_DIMENSION.getCode(), String.format("DashVectorSDK Vector length(%d) is different with collection dimension(%d)", vector.getValue().size(), dimension));
            }
            Validator.verifyVectorType(vector.getValue());
        }
    }

    public static void verifySparseVector(Map<Long, Float> sparseVector, @NonNull CollectionMeta collectionMeta) {
        if (collectionMeta == null) {
            throw new NullPointerException("collectionMeta is marked non-null but is null");
        }
        if (MapUtils.isEmpty(sparseVector)) {
            return;
        }
        if (collectionMeta.getMetric() != CollectionInfo.Metric.dotproduct) {
            throw new DashVectorException(ErrorCode.INVALID_SPARSE_VALUES.getCode(), "DashVectorSDK supports sparse_vector only collection metric is dotproduct");
        }
        Validator.verifySparseVector(sparseVector);
    }

    public static void verifySparseVector(String sparseVectorName, Map<Long, Float> sparseVector, @NonNull CollectionMeta collectionMeta) {
        if (collectionMeta == null) {
            throw new NullPointerException("collectionMeta is marked non-null but is null");
        }
        if (MapUtils.isEmpty(sparseVector)) {
            return;
        }
        if (collectionMeta.getMetric(sparseVectorName) != CollectionInfo.Metric.dotproduct) {
            throw new DashVectorException(ErrorCode.INVALID_SPARSE_VALUES.getCode(), "DashVectorSDK supports sparse_vector only collection metric is dotproduct");
        }
        Validator.verifySparseVector(sparseVector);
    }

    public static boolean verifyEndpoint(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        return ENDPOINT_REGEX.matcher(endpoint).find();
    }

    public static void verifyVectorParam(VectorParam param) {
        Validator.verifyDimension(param.getDimension());
        if (param.getMetric() == CollectionInfo.Metric.cosine && param.getDataType() != CollectionInfo.DataType.FLOAT) {
            throw new DashVectorException(ErrorCode.MISMATCHED_DATA_TYPE.getCode(), "DashVectorSDK CreateCollectionRequest datatype is Invalid and must be [float] when metric is cosine");
        }
    }

    public static void verifyVectorCount(int size) {
        if (size > 4) {
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), VECTORS_LIMIT_MSG);
        }
    }

    public static void verifyVectorNameAndCount(Map<String, ?> vectors) {
        if (MapUtils.isEmpty(vectors)) {
            return;
        }
        if (vectors.size() > 4) {
            throw new DashVectorException(ErrorCode.INVALID_FIELD.getCode(), VECTORS_LIMIT_MSG);
        }
        if (vectors.containsKey(RESERVE_DENSE_VECTOR)) {
            throw new DashVectorException(ErrorCode.INVALID_FIELD_NAME.getCode(), RESERVE_DENSE_VECTOR_MSG);
        }
        vectors.forEach((key, value) -> {
            if (!FIELD_NAME_REGEX.matcher((CharSequence)key).find()) {
                throw new DashVectorException(ErrorCode.INVALID_FIELD_NAME.getCode(), String.format(FIELD_LIMIT_MSG, key));
            }
        });
    }

    private static void verifyVectorType(List<? extends Number> vector) throws DashVectorException {
        if (CollectionUtils.isEmpty(vector)) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT.getCode(), "DashVectorSDK vector is empty");
        }
        Number first = vector.get(0);
        if (!(first instanceof Integer) && !(first instanceof Float)) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_TYPE.getCode(), "DashVectorSDK only support vector type is float and int");
        }
        if (first instanceof Integer && vector.stream().anyMatch(number -> number.intValue() > 127 || number.intValue() < -128)) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT.getCode(), String.format(INT8_LIMIT_MSG, vector));
        }
    }

    private static void verifySparseVector(Map<Long, Float> sparseVector) {
        if (Objects.isNull(sparseVector)) {
            return;
        }
        sparseVector.keySet().stream().filter(key -> key > UINT32_MAXVALUE || key < 0L).findFirst().ifPresent(key -> {
            throw new DashVectorException(ErrorCode.INVALID_SPARSE_INDICES.getCode(), String.format("Sparse vector indices(%d) is invalid and must be in [0, %d]", key, UINT32_MAXVALUE));
        });
    }
}

