/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.validator;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.requests.CreateCollectionRequest;
import com.aliyun.dashvector.proto.CollectionInfo;
import com.aliyun.dashvector.utils.Validator;

public abstract class CreateCollectionValidator {
    protected final CreateCollectionRequest request;

    protected CreateCollectionValidator(CreateCollectionRequest request) {
        this.request = request;
    }

    protected abstract void validateVectorSchema();

    public void validate() {
        Validator.verifyCollectionName(this.request.getName());
        this.validateVectorSchema();
        Validator.verifyFields(this.request.getFiledsSchema());
    }

    public static class MultiVectorCreateCollectionValidator
    extends CreateCollectionValidator {
        protected MultiVectorCreateCollectionValidator(CreateCollectionRequest request) {
            super(request);
        }

        @Override
        protected void validateVectorSchema() {
            Validator.verifyVectorNameAndCount(this.request.getVectors());
        }
    }

    public static class ReserveCreateCollectionValidator
    extends CreateCollectionValidator {
        protected ReserveCreateCollectionValidator(CreateCollectionRequest request) {
            super(request);
        }

        @Override
        protected void validateVectorSchema() {
            if (this.request.getVectorParam() != null) {
                if (this.request.getDimension() > 0) {
                    throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "DashVectorSDK does not support passing in dimension and vector_param simultaneously");
                }
                Validator.verifyVectorParam(this.request.getVectorParam());
            } else {
                Validator.verifyDimension(this.request.getDimension());
                if (this.request.getMetric() == CollectionInfo.Metric.cosine && this.request.getDataType() != CollectionInfo.DataType.FLOAT) {
                    throw new DashVectorException(ErrorCode.MISMATCHED_DATA_TYPE.getCode(), "DashVectorSDK CreateCollectionRequest datatype is Invalid and must be [float] when metric is cosine");
                }
            }
        }
    }
}

