package com.aliyun.openservices.ons.api;

import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;

import java.util.Properties;


/**
 * ONS客户端工厂类，用来创建客户端对象
 */
public class ONSFactory {
    private static ONSFactoryAPI onsFactory = null;

    static {
        try {
            Class<?> factoryClass =
                    ONSFactory.class.getClassLoader().loadClass(
                            "com.aliyun.openservices.ons.api.impl.ONSFactoryNotifyAndMetaQImpl");
            onsFactory = (ONSFactoryAPI) factoryClass.newInstance();
        } catch (Throwable e) {

            try {
                Class<?> factoryClass =
                        ONSFactory.class.getClassLoader().loadClass(
                                "com.aliyun.openservices.ons.api.impl.ONSFactoryImpl");
                onsFactory = (ONSFactoryAPI) factoryClass.newInstance();
            } catch (Throwable e1) {
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
    }


    /**
     * 创建Producer
     *
     * @param properties
     *         Producer的配置参数
     *
     * @return
     */
    public static Producer createProducer(final Properties properties) {
        return onsFactory.createProducer(properties);
    }


    /**
     * 创建顺序Producer
     *
     * @param properties
     *         Producer的配置参数
     *
     * @return
     */
    public static OrderProducer createOrderProducer(final Properties properties) {
        return onsFactory.createOrderProducer(properties);
    }


    /**
     * 创建事务Producer
     *
     * @param properties
     *         Producer的配置参数
     *
     * @return
     */
    public static TransactionProducer createTransactionProducer(final Properties properties,
                                                                final LocalTransactionChecker checker) {
        return onsFactory.createTransactionProducer(properties, checker);
    }


    /**
     * 创建Consumer
     *
     * @param properties
     *         Consumer的配置参数
     *
     * @return
     */
    public static Consumer createConsumer(final Properties properties) {
        return onsFactory.createConsumer(properties);
    }


    /**
     * 创建顺序Consumer
     *
     * @param properties
     *         Consumer的配置参数
     *
     * @return
     */
    public static OrderConsumer createOrderedConsumer(final Properties properties) {
        return onsFactory.createOrderedConsumer(properties);
    }
}
