/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker08
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_08_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker08(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        super(WebSocketVersion.V08, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        String key;
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        if (headers != null) {
            res.headers().add(headers);
        }
        if ((key = req.headers().get("Sec-WebSocket-Key")) == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_08_ACCEPT_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 08 server handshake key: {}, response: {}", (Object)key, (Object)accept);
        }
        res.headers().add("Upgrade", (Object)"WebSocket".toLowerCase());
        res.headers().add("Connection", (Object)"Upgrade");
        res.headers().add("Sec-WebSocket-Accept", (Object)accept);
        String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)subprotocols);
                }
            } else {
                res.headers().add("Sec-WebSocket-Protocol", (Object)selectedSubprotocol);
            }
        }
        return res;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket08FrameDecoder(true, this.allowExtensions, this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket08FrameEncoder(false);
    }
}

