/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.client;

import java.util.Arrays;

public enum APIError {
    GENERAL_BAD_REQUEST(4000000L),
    INVALID_APP_IDENTIFIER(4000002L),
    INVALID_REQUEST_REVISION(4000005L),
    INVALID_TRANSACTION_ID(4000006L),
    INVALID_ORIGINAL_TRANSACTION_ID(4000008L),
    INVALID_EXTEND_BY_DAYS(4000009L),
    INVALID_EXTEND_REASON_CODE(4000010L),
    INVALID_REQUEST_IDENTIFIER(4000011L),
    START_DATE_TOO_FAR_IN_PAST(4000012L),
    START_DATE_AFTER_END_DATE(4000013L),
    INVALID_PAGINATION_TOKEN(4000014L),
    INVALID_START_DATE(4000015L),
    INVALID_END_DATE(4000016L),
    PAGINATION_TOKEN_EXPIRED(4000017L),
    INVALID_NOTIFICATION_TYPE(4000018L),
    MULTIPLE_FILTERS_SUPPLIED(4000019L),
    INVALID_TEST_NOTIFICATION_TOKEN(4000020L),
    INVALID_SORT(4000021L),
    INVALID_PRODUCT_TYPE(4000022L),
    INVALID_PRODUCT_ID(4000023L),
    INVALID_SUBSCRIPTION_GROUP_IDENTIFIER(4000024L),
    INVALID_EXCLUDE_REVOKED(4000025L),
    INVALID_IN_APP_OWNERSHIP_TYPE(4000026L),
    INVALID_EMPTY_STOREFRONT_COUNTRY_CODE_LIST(4000027L),
    INVALID_STOREFRONT_COUNTRY_CODE(4000028L),
    INVALID_REVOKED(4000030L),
    INVALID_STATUS(4000031L),
    INVALID_ACCOUNT_TENURE(4000032L),
    INVALID_APP_ACCOUNT_TOKEN(4000033L),
    INVALID_CONSUMPTION_STATUS(4000034L),
    INVALID_CUSTOMER_CONSENTED(4000035L),
    INVALID_DELIVERY_STATUS(4000036L),
    INVALID_LIFETIME_DOLLARS_PURCHASED(4000037L),
    INVALID_LIFETIME_DOLLARS_REFUNDED(4000038L),
    INVALID_PLATFORM(4000039L),
    INVALID_PLAY_TIME(4000040L),
    INVALID_SAMPLE_CONTENT_PROVIDED(4000041L),
    INVALID_USER_STATUS(4000042L),
    INVALID_TRANSACTION_NOT_CONSUMABLE(4000043L),
    INVALID_TRANSACTION_TYPE_NOT_SUPPORTED(4000047L),
    SUBSCRIPTION_EXTENSION_INELIGIBLE(4030004L),
    SUBSCRIPTION_MAX_EXTENSION(4030005L),
    FAMILY_SHARED_SUBSCRIPTION_EXTENSION_INELIGIBLE(4030007L),
    ACCOUNT_NOT_FOUND(4040001L),
    ACCOUNT_NOT_FOUND_RETRYABLE(4040002L),
    APP_NOT_FOUND(4040003L),
    APP_NOT_FOUND_RETRYABLE(4040004L),
    ORIGINAL_TRANSACTION_ID_NOT_FOUND(4040005L),
    ORIGINAL_TRANSACTION_ID_NOT_FOUND_RETRYABLE(4040006L),
    SERVER_NOTIFICATION_URL_NOT_FOUND(4040007L),
    TEST_NOTIFICATION_NOT_FOUND(4040008L),
    STATUS_REQUEST_NOT_FOUND(4040009L),
    TRANSACTION_ID_NOT_FOUND(4040010L),
    RATE_LIMIT_EXCEEDED(4290000L),
    GENERAL_INTERNAL(5000000L),
    GENERAL_INTERNAL_RETRYABLE(5000001L);

    private final long errorCode;

    private APIError(long errorCode) {
        this.errorCode = errorCode;
    }

    public static APIError fetchErrorResponseFromErrorCode(long errorCode) {
        return Arrays.stream(APIError.values()).filter(v -> v.errorCode == errorCode).findAny().orElse(null);
    }

    public long errorCode() {
        return this.errorCode;
    }
}

