/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.client;

import com.apple.itunes.storekit.client.APIError;

public class APIException
extends Exception {
    private final int httpStatusCode;
    private final Long apiErrorCode;
    private final String apiErrorMessage;

    public APIException(int httpStatusCode, Exception cause) {
        super("Failed to call API with httpStatusCode=" + httpStatusCode, cause);
        this.httpStatusCode = httpStatusCode;
        this.apiErrorCode = null;
        this.apiErrorMessage = null;
    }

    public APIException(int httpStatusCode) {
        super("Failed to call API with httpStatusCode=" + httpStatusCode);
        this.httpStatusCode = httpStatusCode;
        this.apiErrorCode = null;
        this.apiErrorMessage = null;
    }

    public APIException(int httpStatusCode, APIError apiError, String apiErrorMessage) {
        super("Failed to call API with error=\"" + apiErrorMessage + "\"");
        this.httpStatusCode = httpStatusCode;
        this.apiErrorCode = apiError != null ? Long.valueOf(apiError.errorCode()) : null;
        this.apiErrorMessage = apiErrorMessage;
    }

    public APIException(int httpStatusCode, Long rawApiError, String apiErrorMessage) {
        super("Failed to call API with error=\"" + apiErrorMessage + "\"");
        this.httpStatusCode = httpStatusCode;
        this.apiErrorCode = rawApiError;
        this.apiErrorMessage = apiErrorMessage;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public APIError getApiError() {
        return this.apiErrorCode != null ? APIError.fetchErrorResponseFromErrorCode(this.apiErrorCode) : null;
    }

    public Long getRawApiError() {
        return this.apiErrorCode;
    }

    public String getApiErrorMessage() {
        return this.apiErrorMessage;
    }

    @Override
    public String toString() {
        return "APIException{httpStatusCode=" + this.httpStatusCode + ", apiError=" + this.apiErrorCode + ", apiErrorMessage='" + this.apiErrorMessage + "'}";
    }
}

