/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.migration;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;

public class ReceiptUtility {
    private static final int IN_APP_TYPE_ID = 17;
    private static final int TRANSACTION_IDENTIFIER_TYPE_ID = 1703;
    private static final int ORIGINAL_TRANSACTION_IDENTIFIER_TYPE_ID = 1705;

    public String extractTransactionIdFromAppReceipt(String appReceipt) throws IOException {
        try (ASN1InputStream in = new ASN1InputStream(Base64.getDecoder().decode(appReceipt));){
            ASN1Encodable content;
            ASN1Sequence seq;
            ASN1Primitive root = in.readObject();
            if (root instanceof ASN1Sequence && (seq = (ASN1Sequence)root).size() > 1 && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData) && (content = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(1)), (boolean)true)).getContentInfo().getContent()) instanceof ASN1OctetString) {
                try (ASN1InputStream contentStream = new ASN1InputStream(((ASN1OctetString)content).getOctetStream());){
                    ASN1Primitive contentRoot = contentStream.readObject();
                    if (contentRoot instanceof ASN1Set) {
                        String string = Arrays.stream(((ASN1Set)contentRoot).toArray()).filter(ASN1Sequence.class::isInstance).map(ASN1Sequence.class::cast).filter(s -> s.size() == 3).filter(s -> s.getObjectAt(0) instanceof ASN1Integer).filter(s -> ((ASN1Integer)s.getObjectAt(0)).hasValue(17)).filter(s -> s.getObjectAt(2) instanceof ASN1OctetString).flatMap(s -> {
                            try (ASN1InputStream inAppStream = new ASN1InputStream(((ASN1OctetString)s.getObjectAt(2)).getOctetStream());){
                                ASN1Primitive inAppRoot = inAppStream.readObject();
                                if (!(inAppRoot instanceof ASN1Set)) throw new IllegalArgumentException("Invalid App Receipt");
                                Stream<ASN1OctetString> stream = Arrays.stream(((ASN1Set)inAppRoot).toArray()).filter(ASN1Sequence.class::isInstance).map(ASN1Sequence.class::cast).filter(a -> a.size() == 3).filter(a -> a.getObjectAt(0) instanceof ASN1Integer).filter(a -> ((ASN1Integer)a.getObjectAt(0)).hasValue(1703) || ((ASN1Integer)a.getObjectAt(0)).hasValue(1705)).map(a -> a.getObjectAt(2)).map(ASN1OctetString.class::cast);
                                return stream;
                            }
                            catch (IOException e) {
                                throw new IllegalArgumentException("Invalid App Receipt");
                            }
                        }).map(s -> {
                            String string;
                            ASN1InputStream transactionIdentifierStream = new ASN1InputStream(s.getOctetStream());
                            try {
                                ASN1Primitive transactionIdentifierRoot = transactionIdentifierStream.readObject();
                                if (!(transactionIdentifierRoot instanceof ASN1UTF8String)) {
                                    throw new IllegalArgumentException("Invalid App Receipt");
                                }
                                string = ((ASN1UTF8String)transactionIdentifierRoot).getString();
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        transactionIdentifierStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    throw new IllegalArgumentException("Invalid App Receipt");
                                }
                            }
                            transactionIdentifierStream.close();
                            return string;
                        }).findAny().orElse(null);
                        return string;
                    }
                    throw new IllegalArgumentException("Invalid App Receipt");
                }
            }
        }
        return null;
    }

    public String extractTransactionIdFromTransactionReceipt(String transactionReceipt) {
        String encodedPurchaseInfo;
        byte[] decodedTopLevelContainer = Base64.getDecoder().decode(transactionReceipt);
        String topLevel = new String(decodedTopLevelContainer, StandardCharsets.UTF_8);
        Matcher topLevelMatcher = Pattern.compile("\"purchase-info\"\\s+=\\s+\"([a-zA-Z0-9+/=]+)\";").matcher(topLevel);
        String string = encodedPurchaseInfo = topLevelMatcher.find() && topLevelMatcher.groupCount() == 1 ? topLevelMatcher.group(1) : null;
        if (encodedPurchaseInfo == null) {
            throw new IllegalArgumentException("Invalid purchase-info");
        }
        byte[] decodedPurchaseInfoContainer = Base64.getDecoder().decode(encodedPurchaseInfo);
        String purchaseInfo = new String(decodedPurchaseInfoContainer, StandardCharsets.UTF_8);
        Matcher purchaseInfoMatcher = Pattern.compile("\"transaction-id\"\\s+=\\s+\"([a-zA-Z0-9+/=]+)\";").matcher(purchaseInfo);
        return purchaseInfoMatcher.find() && purchaseInfoMatcher.groupCount() == 1 ? purchaseInfoMatcher.group(1) : null;
    }
}

