/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.offers;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.UUID;

public class PromotionalOfferSignatureCreator {
    private final ECPrivateKey signingKey;
    private final String keyId;
    private final String bundleId;

    public PromotionalOfferSignatureCreator(String signingKey, String keyId, String bundleId) {
        try {
            signingKey = signingKey.replace("-----BEGIN PRIVATE KEY-----", "").replaceAll("\\R+", "").replace("-----END PRIVATE KEY-----", "");
            byte[] derEncodedSigningKey = Base64.getDecoder().decode(signingKey);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(derEncodedSigningKey);
            this.signingKey = (ECPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        this.keyId = keyId;
        this.bundleId = bundleId;
    }

    public String createSignature(String productIdentifier, String subscriptionOfferID, String appAccountToken, UUID nonce, long timestamp) {
        String payload = this.bundleId + "\u2063" + this.keyId + "\u2063" + productIdentifier + "\u2063" + subscriptionOfferID + "\u2063" + appAccountToken.toLowerCase() + "\u2063" + nonce.toString().toLowerCase() + "\u2063" + timestamp;
        try {
            Signature s = Signature.getInstance("SHA256withECDSA");
            s.initSign(this.signingKey);
            s.update(payload.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(s.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

