/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.verification;

import com.apple.itunes.storekit.model.AppTransaction;
import com.apple.itunes.storekit.model.DecodedSignedData;
import com.apple.itunes.storekit.model.Environment;
import com.apple.itunes.storekit.model.JWSRenewalInfoDecodedPayload;
import com.apple.itunes.storekit.model.JWSTransactionDecodedPayload;
import com.apple.itunes.storekit.model.ResponseBodyV2DecodedPayload;
import com.apple.itunes.storekit.verification.ChainVerifier;
import com.apple.itunes.storekit.verification.VerificationException;
import com.apple.itunes.storekit.verification.VerificationStatus;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.util.Base64;
import java.util.Date;
import java.util.Set;

public class SignedDataVerifier {
    private final String bundleId;
    private final Long appAppleId;
    private final Environment environment;
    private final ChainVerifier chainVerifier;
    private final boolean enableOnlineChecks;
    private final ObjectMapper objectMapper;

    public SignedDataVerifier(Set<InputStream> rootCertificates, String bundleId, Long appAppleId, Environment environment, boolean enableOnlineChecks) {
        this.bundleId = bundleId;
        this.appAppleId = appAppleId;
        this.environment = environment;
        this.chainVerifier = new ChainVerifier(rootCertificates);
        this.enableOnlineChecks = enableOnlineChecks;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        if (appAppleId == null && Environment.PRODUCTION.equals((Object)environment)) {
            throw new IllegalArgumentException("appAppleId is required when the environment is Production");
        }
    }

    public JWSTransactionDecodedPayload verifyAndDecodeTransaction(String signedTransaction) throws VerificationException {
        JWSTransactionDecodedPayload transaction = this.decodeSignedObject(signedTransaction, JWSTransactionDecodedPayload.class);
        if (!this.bundleId.equals(transaction.getBundleId())) {
            throw new VerificationException(VerificationStatus.INVALID_APP_IDENTIFIER);
        }
        if (!this.environment.equals((Object)transaction.getEnvironment())) {
            throw new VerificationException(VerificationStatus.INVALID_ENVIRONMENT);
        }
        return transaction;
    }

    public JWSRenewalInfoDecodedPayload verifyAndDecodeRenewalInfo(String signedRenewalInfo) throws VerificationException {
        JWSRenewalInfoDecodedPayload renewalInfo = this.decodeSignedObject(signedRenewalInfo, JWSRenewalInfoDecodedPayload.class);
        if (!this.environment.equals((Object)renewalInfo.getEnvironment())) {
            throw new VerificationException(VerificationStatus.INVALID_ENVIRONMENT);
        }
        return renewalInfo;
    }

    public ResponseBodyV2DecodedPayload verifyAndDecodeNotification(String signedPayload) throws VerificationException {
        Environment notificationEnv;
        Long appAppleId;
        String bundleId;
        ResponseBodyV2DecodedPayload notification = this.decodeSignedObject(signedPayload, ResponseBodyV2DecodedPayload.class);
        if (notification.getData() != null) {
            bundleId = notification.getData().getBundleId();
            appAppleId = notification.getData().getAppAppleId();
            notificationEnv = notification.getData().getEnvironment();
        } else if (notification.getSummary() != null) {
            bundleId = notification.getSummary().getBundleId();
            appAppleId = notification.getSummary().getAppAppleId();
            notificationEnv = notification.getSummary().getEnvironment();
        } else if (notification.getExternalPurchaseToken() != null) {
            bundleId = notification.getExternalPurchaseToken().getBundleId();
            appAppleId = notification.getExternalPurchaseToken().getAppAppleId();
            String externalPurchaseId = notification.getExternalPurchaseToken().getExternalPurchaseId();
            notificationEnv = externalPurchaseId != null && externalPurchaseId.startsWith("SANDBOX") ? Environment.SANDBOX : Environment.PRODUCTION;
        } else {
            bundleId = null;
            appAppleId = null;
            notificationEnv = null;
        }
        this.verifyNotification(bundleId, appAppleId, notificationEnv);
        return notification;
    }

    protected void verifyNotification(String bundleId, Long appAppleId, Environment notificationEnv) throws VerificationException {
        if (!this.bundleId.equals(bundleId) || this.environment.equals((Object)Environment.PRODUCTION) && !this.appAppleId.equals(appAppleId)) {
            throw new VerificationException(VerificationStatus.INVALID_APP_IDENTIFIER);
        }
        if (!this.environment.equals((Object)notificationEnv)) {
            throw new VerificationException(VerificationStatus.INVALID_ENVIRONMENT);
        }
    }

    public AppTransaction verifyAndDecodeAppTransaction(String signedAppTransaction) throws VerificationException {
        AppTransaction appTransaction = this.decodeSignedObject(signedAppTransaction, AppTransaction.class);
        Environment environment = appTransaction.getReceiptType();
        if (!this.bundleId.equals(appTransaction.getBundleId()) || this.environment.equals((Object)Environment.PRODUCTION) && !this.appAppleId.equals(appTransaction.getAppAppleId())) {
            throw new VerificationException(VerificationStatus.INVALID_APP_IDENTIFIER);
        }
        if (!this.environment.equals((Object)environment)) {
            throw new VerificationException(VerificationStatus.INVALID_ENVIRONMENT);
        }
        return appTransaction;
    }

    protected <T extends DecodedSignedData> T decodeSignedObject(String signedObject, Class<T> clazz) throws VerificationException {
        try {
            DecodedJWT unverifiedJWT = JWT.decode((String)signedObject);
            if (Environment.XCODE.equals((Object)this.environment) || Environment.LOCAL_TESTING.equals((Object)this.environment)) {
                return this.parseJWTPayload(clazz, unverifiedJWT);
            }
            String[] x5cChain = (String[])unverifiedJWT.getHeaderClaim("x5c").asArray(String.class);
            if (x5cChain == null) {
                throw new VerificationException(VerificationStatus.VERIFICATION_FAILURE, "x5c claim was null");
            }
            T decodedData = this.parseJWTPayload(clazz, unverifiedJWT);
            Date effectiveDate = this.enableOnlineChecks || decodedData.getSignedDate() == null ? new Date() : new Date(decodedData.getSignedDate());
            PublicKey signingKey = this.chainVerifier.verifyChain(x5cChain, this.enableOnlineChecks, effectiveDate);
            if (!"ES256".equals(unverifiedJWT.getAlgorithm())) {
                throw new VerificationException(VerificationStatus.VERIFICATION_FAILURE, "Unrecognized JWT algorithm + " + unverifiedJWT.getAlgorithm());
            }
            JWT.require((Algorithm)Algorithm.ECDSA256((ECKey)((ECPublicKey)signingKey))).build().verify(unverifiedJWT);
            return decodedData;
        }
        catch (VerificationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VerificationException(VerificationStatus.VERIFICATION_FAILURE, (Throwable)e);
        }
    }

    protected <T extends DecodedSignedData> T parseJWTPayload(Class<T> clazz, DecodedJWT jwt) throws VerificationException {
        String payload = new String(Base64.getUrlDecoder().decode(jwt.getPayload()));
        try {
            return (T)((DecodedSignedData)this.objectMapper.readValue(payload, clazz));
        }
        catch (JsonProcessingException e) {
            throw new VerificationException(VerificationStatus.VERIFICATION_FAILURE, (Throwable)e);
        }
    }
}

