/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.advancedcommerce;

import com.apple.itunes.storekit.model.AdvancedCommerceInAppRequest;
import com.apple.itunes.storekit.signature.JWSSignatureCreator;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;

public class AdvancedCommerceInAppSignatureCreator
extends JWSSignatureCreator {
    private static final String AUDIENCE = "advanced-commerce-api";
    private static final String REQUEST_KEY = "request";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AdvancedCommerceInAppSignatureCreator(String signingKey, String keyId, String issuerId, String bundleId) {
        super(AUDIENCE, signingKey, keyId, issuerId, bundleId);
        this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    public String createSignature(AdvancedCommerceInAppRequest advancedCommerceInAppRequest) throws IOException {
        if (advancedCommerceInAppRequest == null) {
            throw new IllegalArgumentException("advancedCommerceInAppRequest cannot be null");
        }
        String jsonRequest = this.objectMapper.writeValueAsString((Object)advancedCommerceInAppRequest);
        byte[] utf8Bytes = jsonRequest.getBytes(StandardCharsets.UTF_8);
        String encodedRequest = Base64.getEncoder().encodeToString(utf8Bytes);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(REQUEST_KEY, encodedRequest);
        return this.createSignature(claims);
    }
}

