/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.client;

import com.apple.itunes.storekit.client.BaseAppStoreServerAPIClient;
import com.apple.itunes.storekit.client.BearerTokenAuthenticator;
import com.apple.itunes.storekit.client.BearerTokenAuthenticatorInterface;
import com.apple.itunes.storekit.model.Environment;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AppStoreServerAPIClient
extends BaseAppStoreServerAPIClient {
    private final OkHttpClient httpClient;
    private final HttpUrl urlBase;

    public AppStoreServerAPIClient(String signingKey, String keyId, String issuerId, String bundleId, Environment environment) {
        this(new BearerTokenAuthenticator(signingKey, keyId, issuerId, bundleId), environment);
    }

    public AppStoreServerAPIClient(BearerTokenAuthenticatorInterface bearerTokenAuthenticator, Environment environment) {
        super(bearerTokenAuthenticator, environment);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.proxyAuthenticator(Authenticator.JAVA_NET_AUTHENTICATOR);
        this.httpClient = builder.build();
        this.urlBase = HttpUrl.parse((String)this.url);
    }

    @Override
    protected BaseAppStoreServerAPIClient.HttpResponseInterface makeRequest(String path, String method, Map<String, List<String>> queryParameters, Map<String, String> headers, String contentType, String body) throws IOException {
        Request.Builder requestBuilder = new Request.Builder();
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(this.urlBase.resolve(path)).newBuilder();
        for (Map.Entry<String, List<String>> entry : queryParameters.entrySet()) {
            for (String queryValue : entry.getValue()) {
                urlBuilder.addQueryParameter(entry.getKey(), queryValue);
            }
        }
        requestBuilder.url(urlBuilder.build());
        if (body != null) {
            MediaType mediaType = contentType != null ? MediaType.parse((String)contentType) : null;
            requestBuilder.method(method, RequestBody.create((String)body, (MediaType)mediaType));
        } else {
            requestBuilder.method(method, null);
        }
        return new OkHttpResponse(this.getResponse(requestBuilder.build()));
    }

    protected Response getResponse(Request request) throws IOException {
        Call call = this.httpClient.newCall(request);
        return call.execute();
    }

    protected static class OkHttpResponse
    implements BaseAppStoreServerAPIClient.HttpResponseInterface {
        private final Response response;

        public OkHttpResponse(Response response) {
            this.response = response;
        }

        @Override
        public int statusCode() {
            return this.response.code();
        }

        @Override
        public Reader body() {
            ResponseBody responseBody = this.response.body();
            return responseBody != null ? responseBody.charStream() : null;
        }

        @Override
        public void close() {
            this.response.close();
        }
    }
}

