/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.offers;

import com.apple.itunes.storekit.signature.JWSSignatureCreator;
import java.util.HashMap;

public class IntroductoryOfferEligibilitySignatureCreator
extends JWSSignatureCreator {
    private static final String AUDIENCE = "introductory-offer-eligibility";
    private static final String PRODUCT_ID_KEY = "productId";
    private static final String ALLOW_INTRODUCTORY_OFFER_KEY = "allowIntroductoryOffer";
    private static final String TRANSACTION_ID_KEY = "transactionId";

    public IntroductoryOfferEligibilitySignatureCreator(String signingKey, String keyId, String issuerId, String bundleId) {
        super(AUDIENCE, signingKey, keyId, issuerId, bundleId);
    }

    public String createSignature(String productId, boolean allowIntroductoryOffer, String transactionId) {
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("transactionId cannot be null");
        }
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(PRODUCT_ID_KEY, productId);
        claims.put(ALLOW_INTRODUCTORY_OFFER_KEY, allowIntroductoryOffer);
        claims.put(TRANSACTION_ID_KEY, transactionId);
        return this.createSignature(claims);
    }
}

