/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.storekit.offers;

import com.apple.itunes.storekit.signature.JWSSignatureCreator;
import java.util.HashMap;

public class PromotionalOfferV2SignatureCreator
extends JWSSignatureCreator {
    private static final String AUDIENCE = "promotional-offer";
    private static final String PRODUCT_ID_KEY = "productId";
    private static final String OFFER_IDENTIFIER_KEY = "offerIdentifier";
    private static final String TRANSACTION_ID_KEY = "transactionId";

    public PromotionalOfferV2SignatureCreator(String signingKey, String keyId, String issuerId, String bundleId) {
        super(AUDIENCE, signingKey, keyId, issuerId, bundleId);
    }

    public String createSignature(String productId, String offerIdentifier, String transactionId) {
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        if (offerIdentifier == null) {
            throw new IllegalArgumentException("offerIdentifier cannot be null");
        }
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(PRODUCT_ID_KEY, productId);
        claims.put(OFFER_IDENTIFIER_KEY, offerIdentifier);
        if (transactionId != null) {
            claims.put(TRANSACTION_ID_KEY, transactionId);
        }
        return this.createSignature(claims);
    }
}

