package com.bxm.abtest.adx.config;

import com.bxm.abtest.adx.properties.AbtestShuntProperties;
import com.bxm.openlog.extension.client.HttpClientOpenLogClient;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import redis.clients.jedis.JedisPool;

/**
 * @author zhangdong
 * @date 2025/2/18
 */

@ConditionalOnProperty(value = AbtestShuntProperties.PROPERTY_ENABLE, havingValue = "true")
@ComponentScan("com.bxm.abtest.adx")
@EnableConfigurationProperties(AbtestShuntProperties.class)
public class AbtestAdxConfig {

    @Bean
    @ConditionalOnMissingBean
    public OpenLogClient openLogClient() {
        return HttpClientOpenLogClient.builder().setMaxTotal(200).setDefaultMaxPerRoute(200).setSocketTimeout(800).build();
    }

    @Bean
    public JedisPool abtestAdxJedisPool(AbtestShuntProperties properties) {
        JedisConfiguration configuration = properties.getRedisConfig();
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }

    @Bean
    public LoadingCacheFetcher abtestAdxLoadingCacheFetcher(@Qualifier("abtestAdxJedisPool") JedisPool jedisPool) {
        return new LoadingCacheFetcher(new RedisFetcher(jedisPool));
    }

    @Bean
    @ConditionalOnMissingBean(AsyncEventPark.class)
    public EventPark adtestAdxEventPark(){
        return new AsyncEventPark();
    }


}
