package com.bxm.abtest.adx.facade;

import com.bxm.abtest.adx.listener.event.SuccessResponseEvent;
import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.adx.strategy.experiment.CutFlowFactory;
import com.bxm.abtest.adx.strategy.version.VersionFlowFactory;
import com.bxm.abtest.common.key.RedisExperimentKey;
import com.bxm.abtest.common.utils.MurmursUtils;
import com.bxm.abtest.facade.module.AbtestShuntRequest;
import com.bxm.abtest.facade.module.AbtestShuntResponse;
import com.bxm.abtest.facade.service.AbtestShuntFacadeService;
import com.bxm.abtest.model.dto.ExperimentVersionRatioConfigDTO;
import com.bxm.abtest.model.enums.ExperimentStatusEnum;
import com.bxm.abtest.model.vo.ExperimentConfigVO;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.xcache.TargetFactory;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
public class AbtestShuntFacadeImpl implements AbtestShuntFacadeService {


    private final CutFlowFactory cutFlowFactory;
    private final VersionFlowFactory versionFlowFactory;
    private final LoadingCacheFetcher loadingCacheFetcher;
    private final EventPark eventPark;

    public AbtestShuntFacadeImpl(@Qualifier("abtestAdxLoadingCacheFetcher") LoadingCacheFetcher loadingCacheFetcher, CutFlowFactory cutFlowFactory, VersionFlowFactory versionFlowFactory, EventPark eventPark) {
        this.loadingCacheFetcher = loadingCacheFetcher;
        this.cutFlowFactory = cutFlowFactory;
        this.versionFlowFactory = versionFlowFactory;
        this.eventPark = eventPark;
    }

    @Override
    public AbtestShuntResponse getShuntVersion(AbtestShuntRequest request) {
        //1.缓存拉取数据
        Map<String, ExperimentConfigVO> allmap = loadingCacheFetcher.hfetchall(new TargetFactory<ExperimentConfigVO>()
                .keyGenerator(RedisExperimentKey.experimentConfigSceneKey(request.getExperimentSceneCode()))
                .cls(ExperimentConfigVO.class).build());
        String defaultVersion = loadingCacheFetcher.hfetch(new TargetFactory<String>()
                .keyGenerator(RedisExperimentKey.experimentSceneDefaultVersion())
                .field(request.getExperimentSceneCode()).cls(String.class).build());
        AbtestShuntResponse defaultResponse = StringUtils.isEmpty(defaultVersion) ? null : new AbtestShuntResponse(defaultVersion);
        if (allmap == null || allmap.isEmpty()) {
            return defaultResponse;
        }
        List<ExperimentConfigVO> experimentConfigs = Lists.newArrayList(allmap.values());
        experimentConfigs = experimentConfigs.stream().filter(x -> ExperimentStatusEnum.RUNNING.getStatus().equals(x.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(experimentConfigs)) {
            return defaultResponse;
        }
        String userId = request.getUserId();
        String sceneCode = request.getExperimentSceneCode();
        //2.计算用户的hash
        BigDecimal hash = new BigDecimal(Math.abs(MurmursUtils.hash(userId, Integer.parseInt(sceneCode)).intValue() % 100));
        //3.组装请求对象
        RequestContext context = new RequestContext();
        context.setRequest(request).setUserHash(hash).setCandidateExperiment(experimentConfigs);
        //4.根据流量比例选择实验
        ExperimentConfigVO vo = cutFlowFactory.chooseExperiment(context);
        if (vo == null) {
            return defaultResponse;
        }
        context.setHitExperiment(vo);
        //5.根据版本比例选择实验版本
        ExperimentVersionRatioConfigDTO dto = versionFlowFactory.chooseExperimentVersion(context);
        if (dto == null) {
            return defaultResponse;
        }
        context.setHitVersion(dto);
        //6.实验成功请求成功的后置处理
        this.eventPark.post(new SuccessResponseEvent(this, context));
        return new AbtestShuntResponse(dto.getVersionCode());
    }


}
