package com.bxm.abtest.adx.listener;

import com.bxm.abtest.adx.listener.event.SuccessResponseEvent;
import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.adx.properties.AbtestShuntProperties;
import com.bxm.abtest.facade.enums.RequestTypeEnum;
import com.bxm.abtest.facade.module.AbtestShuntRequest;
import com.bxm.abtest.model.dto.ExperimentVersionRatioConfigDTO;
import com.bxm.abtest.model.vo.ExperimentConfigVO;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
@Slf4j
public class SuccessResponseListener implements EventListener<SuccessResponseEvent> {

    private final OpenLogClient openLogClient;
    private final AbtestShuntProperties abtestShuntProperties;

    public SuccessResponseListener(OpenLogClient openLogClient, AbtestShuntProperties abtestShuntProperties) {
        this.openLogClient = openLogClient;
        this.abtestShuntProperties = abtestShuntProperties;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(SuccessResponseEvent event) {
        RequestContext context = event.getContext();
        String openLogUrl = buildOpenLogUrl(context.getRequest(), context.getHitExperiment(), context.getHitVersion());
        openLogClient.asyncRequest(openLogUrl,
                fallback -> log.error("abtest openLog send error url:{}", fallback.getUrl(), fallback.getException()));
    }

    private String buildOpenLogUrl(AbtestShuntRequest request, ExperimentConfigVO vo, ExperimentVersionRatioConfigDTO dto) {
        KeyValueMap log = new KeyValueMap();
        Integer requestType = request.getRequestType();
        String logName = RequestTypeEnum.getLogNameByType(requestType);
        log.setProduction(Production.COMMON);
        log.setMt(Common.Mt.Abtest.original());
        log.put(Common.AbtestParam.UID, request.getUserId());
        log.put(Common.AbtestParam.TIME, System.currentTimeMillis());
        log.put(Common.AbtestParam.TAG_ID, request.getPositionId());
        log.put(Common.AbtestParam.EXPERIMENT_ID, vo.getId());
        log.put(Common.AbtestParam.VERSION_CODE, dto.getId());
        log.put(Common.AbtestParam.BUSINESS_SCENE, requestType);
        if (StringUtils.isNotEmpty(logName)) {
            log.put(logName, request.getUniqueId());
        }
        return log.createOpenLogRequestUri(abtestShuntProperties.getOpenLogRequestDomain());
    }


}
