package com.bxm.abtest.adx.strategy.experiment;

import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.model.vo.ExperimentConfigVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
public class CutFlowFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<Integer, CutFlowStrategy> map = new HashMap<>();

    public ExperimentConfigVO chooseExperiment(RequestContext context) {
        List<ExperimentConfigVO> vos = context.getCandidateExperiment();
        if (map.isEmpty() || CollectionUtils.isEmpty(vos)) {
            return null;
        }
        CutFlowStrategy cutFlowStrategy = map.get(vos.get(0).getCutFlowType());
        if (cutFlowStrategy == null) {
            return null;
        }
        return cutFlowStrategy.chooseExperiment(context);
    }


    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, CutFlowStrategy> strategyMap = applicationContext.getBeansOfType(CutFlowStrategy.class);
        strategyMap.values().forEach(x -> map.put(x.type(), x));
    }
}
