package com.bxm.abtest.adx.strategy.experiment;

import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.model.dto.ExperimentPositionRatioConfigDTO;
import com.bxm.abtest.model.enums.ExperimentCutFlowTypeEnum;
import com.bxm.abtest.model.vo.ExperimentConfigVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
public class PositionCutFlowStrategy implements CutFlowStrategy {
    @Override
    public Integer type() {
        return ExperimentCutFlowTypeEnum.POSITION.getType();
    }

    @Override
    public ExperimentConfigVO chooseExperiment(RequestContext context) {
        BigDecimal all = new BigDecimal(0);
        BigDecimal hash = context.getUserHash();
        String positionId = context.getRequest().getPositionId();
        for (ExperimentConfigVO vo : context.getCandidateExperiment()) {
            List<ExperimentPositionRatioConfigDTO> positionConfigs = vo.getPositionRatioConfigList();
            if (CollectionUtils.isEmpty(positionConfigs)) {
                continue;
            }
            for (ExperimentPositionRatioConfigDTO dto : positionConfigs) {
                if (!positionId.equals(dto.getPositionId())) {
                    continue;
                }
                all = all.add(dto.getPositionRatio());
                break;
            }
            if (hash.compareTo(all) < 0) {
                return vo;
            }
        }
        return null;
    }
}
