package com.bxm.abtest.adx.strategy.experiment;

import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.model.enums.ExperimentCutFlowTypeEnum;
import com.bxm.abtest.model.vo.ExperimentConfigVO;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
public class WholeCutFlowStrategy implements CutFlowStrategy {
    @Override
    public Integer type() {
        return ExperimentCutFlowTypeEnum.WHOLE.getType();
    }

    @Override
    public ExperimentConfigVO chooseExperiment(RequestContext context) {
        BigDecimal all = new BigDecimal(0);
        BigDecimal hash = context.getUserHash();
        for (ExperimentConfigVO vo : context.getCandidateExperiment()) {
            all = all.add(vo.getWholeRatio());
            if (hash.compareTo(all) < 0) {
                return vo;
            }
        }
        return null;
    }
}
