package com.bxm.abtest.adx.strategy.version;

import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.model.dto.ExperimentVersionRatioConfigDTO;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
public class DefaultVersionFlowStrategy implements VersionFlowStrategy {
    @Override
    public ExperimentVersionRatioConfigDTO chooseExperimentVersion(RequestContext context) {
        BigDecimal hash = context.getUserHash();
        BigDecimal all = new BigDecimal(0);
        for (ExperimentVersionRatioConfigDTO dto : context.getHitExperiment().getVersionRatioConfigList()) {
            all = all.add(dto.getVersionRatio());
            if (hash.compareTo(all) < 0) {
                return dto;
            }
        }
        return null;
    }
}
