package com.bxm.abtest.adx.strategy.version;

import com.bxm.abtest.adx.model.RequestContext;
import com.bxm.abtest.model.dto.ExperimentVersionRatioConfigDTO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Component
public class VersionFlowFactory implements ApplicationListener<ApplicationReadyEvent> {
    private List<VersionFlowStrategy> strategyList;

    public ExperimentVersionRatioConfigDTO chooseExperimentVersion(RequestContext context) {
        List<ExperimentVersionRatioConfigDTO> vos = context.getHitExperiment().getVersionRatioConfigList();
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        for (VersionFlowStrategy strategy : strategyList) {
            ExperimentVersionRatioConfigDTO dto = strategy.chooseExperimentVersion(context);
            if (dto != null) {
                return dto;
            }
        }
        return null;
    }


    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, VersionFlowStrategy> beansOfType = applicationContext.getBeansOfType(VersionFlowStrategy.class);
        strategyList = beansOfType.values().stream().sorted(Comparator.comparingInt(VersionFlowStrategy::getOrder)).collect(Collectors.toList());
    }
}
