package com.bxm.abtest.facade.constant;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;


public interface RedisKeyGenerators {


    /**
     * 根据场景获取流量情况
     *
     * @param senceCode
     * @return
     */
    public static KeyGenerator keyGeneratorBySenceCode(String senceCode) {
        return () -> KeyBuilder.build("ABTEST", "BUSINESS", "SCENE", senceCode);
    }


    /**
     * 算法名称
     *
     * @param requestId
     * @return
     */
    public static KeyGenerator keyGeneratorByRequestId(String requestId) {
        return () -> KeyBuilder.build("ABTEST", "ALGORITHM", "NAME", requestId);
    }
}
