package com.bxm.abtest.facade.model;


import lombok.Data;

import java.io.Serializable;


/**
 * ABTest 实验请求参数
 * @author 拉拉
 * @version v1.0.0
 */
@Data
public class AlgorithmRequest implements Serializable {


    private static final long serialVersionUID = 814354254864643906L;

    /**
     * <p>用户ID</p>
     * <p>默认情况下会使用这个来作为AB分桶的参数，如果使用随机分桶，那么用户ID可以不填。</p>
     * <p>
     *     建议：有设备号的流量可以传 IMEI、oaid、IDFA，互动广告可以传 UID
     * </p>
     */
    private String userId;

    /**
     * 广告位
     */
    private String positionId;

    /**
     * 业务场景对应的 code 值
     */
    private String sceneCode;

    /**
     * <p>请求ID</p>
     * <p>对请求AB分桶后，如果后续希望回溯这个请求当时命中哪个算法，那么需要再次用到这个请求ID来查询</p>
     * <p>建议：互动广告的spm,bxmId、SDK 的bidid</p>
     */
    private String requestId;

    /**
     * <p>分桶逻辑</p>
     * <ul>
     * <li>default - 默认。根据 userId + sceneCode 使用MurmursHashCode分桶</li>
     * <li>random - 根据流量随机分桶</li>
     * </ul>
     */
    private String source;

    /**
     * <p>前置名称，回溯时，返回的算法名称的前缀。</p>
     * <pre>
     *     举例说明：
     *     1、请求 /abtest/api/getAlgorithmCode 时传入 beforeName=DNN，返回命中的算法名称是：10019
     *     2、根据请求ID回溯 /abtest/api/getAlgorithmNamebyParams 时，返回的算法名称则是：DNN-10019
     * </pre>
     */
    private String beforeName;
}
