/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.acl.model.constant;

/**
 * 类Constant.java的实现描述:求常量类
 * 
 * @author leon 2016年8月11日 下午2:29:08
 */
public class Constant {

    /**
     * 系统默认页码
     */
    public static final int    DEFAULT_PAGE_NUM              = 1;

    /**
     * 系统默认每页数量
     */
    public static final int    DEFAULT_PAGE_SIZE             = 10;

    /**
     * 系统默认每页最大数量
     */
    public static final int    DEFAULT_MAX_PAGE_SIZE         = 50;

    /**
     * 系统默认排序字段
     */
    public static final String DEFAULT_ORDER_PARAM           = "updated";

    /**
     * 系统默认排序方式
     */
    public static final String DEFAULT_ORDER_TYPE            = "desc";

    /**
     * 图片验证码cookie key
     */
    public static final String IMG_VALIDATE_CODE_KEY         = "img_validate_code_key";
    /**
     * 注册短信验证码超时时间cookie key
     */
    public static final String MSG_COED_KEY_LAST_ACCESS_TIME = "msg_coed_key_last_access_time";

    /**
     * 短信验证码有效数间
     */
    public static final int    MSG_CODE_EFFECTIVE_TIME       = 60 * 5;                                        // 300秒,5分钟
    /**
     * 短信验证码发送间隔数间
     */
    public static final int    MSG_CODE_SEND_INTERVAL        = 60 * 1000 * 2;                                 // 120000
                                                                                                              // 毫秒=2分钟
    /**
     * 注册用户登录 session key
     */
    public static final String SESSION_LOGIN_KEY             = "session_login_key";

    /**
     * 用户登录 session 有效期:两小时，单位秒
     */
    public static final int    LOGIN_SESSION_EFFECTIVE_TIME  = 60 * 60 * 2;

    /**
     * 存短信验证码发送次数的redis key：0-ip,1-手机号码
     */
    public static final String MSG_VALIDATE_SEND_COUNT_KEY   = "acl:msgvalidate:ipSendCount:ip:{0}:phone:{1}";

    /**
     * 存短信验证码的redis key，0-手机号码
     */
    public static final String MSG_VALIDATE_REDIS_KEY        = "acl:msgvalidate:phone:{0}";

}
