package com.bxm.activites.facade.model;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 弹窗数据请求对象
 *
 * @ClassName PopupDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/8/8 11:44
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/8/8 11:44
 **/
public class PopupDto implements Serializable{

    private static final long serialVersionUID = 6116479035584826526L;
    /**
     * 开发者ID
     */
    @DefaultValue("mistake_appKey")
    @ValidateNotNull
    public String appkey;

    /**
     * 渠道
     */
    @DefaultValue("mistake_biz")
    @ValidateNotNull
    public String business;

    /**
     * 活动ID
     */
    @DefaultValue("0")
    @ValidateNotNull
    public Long activityid;

    /**
     * 弹窗类型  0--普通弹窗  1--首张弹窗  2--挽留弹窗
     */
    @DefaultValue("2")
    @ValidateNotNull
    public Integer popupType;

    /**
     * 按逗号分隔
     */
    private String usedPopupIds;

    /**
     * 弹窗ID,按逗号隔开
     */
    private String ids;

    public String getPositionId() {
        return StringUtils.join(new Object []{appkey, business.replaceAll("ad-|money-", "")}, "-");
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Long getActivityid() {
        return activityid;
    }

    public void setActivityid(Long activityid) {
        this.activityid = activityid;
    }

    public Integer getPopupType() {
        return popupType;
    }

    public void setPopupType(Integer popupType) {
        this.popupType = popupType;
    }


    public String getUsedPopupIds() {
        return usedPopupIds;
    }

    public void setUsedPopupIds(String usedPopupIds) {
        this.usedPopupIds = usedPopupIds;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }
}
