package com.bxm.activites.facade.model;

import java.io.Serializable;

public class WeightEntry implements Comparable<WeightEntry>,Serializable {

    private Integer activityId;
    private Integer interventionFactor;//人工系数，tbl_activity_position_relation.weight
    private double weight  = 0.01;//人均券点击
    private long uv;//活动曝光uv

    @Override
    public int compareTo(WeightEntry o) {
        return Double.compare(o.getWeight() * o.getInterventionFactor(), weight * interventionFactor);
    }

    public WeightEntry(Integer activityId, double weight, long uv, Integer interventionFactor) {
        super();
        this.activityId = activityId;
        this.weight = weight;
        this.uv = uv;
        this.interventionFactor = interventionFactor != null ? interventionFactor : 100;
    }

    public long getUv() {
        return uv;
    }

    public void setUv(int uv) {
        this.uv = uv;
    }

    public Integer getInterventionFactor() {
        return interventionFactor;
    }

    public void setInterventionFactor(Integer interventionFactor) {
        this.interventionFactor = interventionFactor;
    }

    public Integer getActivityId() {
        return activityId;
    }
    public void setActivityId(Integer activityId) {
        this.activityId = activityId;
    }
    public double getWeight() {
        return weight;
    }
    public void setWeight(double weight) {
        this.weight = weight;
    }
}